#if !defined( __RANGE3D_H )
#define __RANGE3D_H

// Bounding box class
class Range3D {
	float bounds[2][3];
public:
	float *operator[](int index) { return bounds[index]; }
	Range3D &operator=(Range3D &r) {
		for (int i=0;i<3;i++) {
			bounds[0][i] = r.bounds[0][i];
			bounds[1][i] = r.bounds[1][i];
		}
		return *this;
	}
	Range3D &operator+=(Range3D &r) {
		for (int i=0;i<3;i++) {
			if (r.bounds[0][i] < bounds[0][i])
				bounds[0][i] = r.bounds[0][i];
			if (r.bounds[1][i] > bounds[1][i])
				bounds[1][i] = r.bounds[1][i];
		}
		return *this;
	}
	bool operator==(Range3D &r) {
		return bounds[0][0] == r.bounds[0][0] &&
			   bounds[0][1] == r.bounds[0][1] &&
			   bounds[0][2] == r.bounds[0][2] &&
			   bounds[1][0] == r.bounds[1][0] &&
			   bounds[1][1] == r.bounds[1][1] &&
			   bounds[1][2] == r.bounds[1][2];
	}
	// Does this box intersect the box r?
	bool Intersects(Range3D &r) {
		if (r.bounds[1][0] < bounds[0][0] ||
			r.bounds[1][1] < bounds[0][1] ||
			r.bounds[1][2] < bounds[0][2])
			return false;
		if (bounds[1][0] < r.bounds[0][0] ||
			bounds[1][1] < r.bounds[0][1] ||
			bounds[1][2] < r.bounds[0][2])
			return false;
		return true;
	}
	// Does this box completly contain the box r?
	bool Contains(Range3D &r, float eps) {
		if (r.bounds[0][0] >= bounds[0][0] - eps &&
			r.bounds[1][0] <= bounds[1][0] + eps &&
			r.bounds[0][1] >= bounds[0][1] - eps &&
			r.bounds[1][1] <= bounds[1][1] + eps &&
			r.bounds[0][2] >= bounds[0][2] - eps &&
			r.bounds[1][2] <= bounds[1][2] + eps)
			return true;
		else
			return false;
	}
	// Does this box completly contain the box r?
	bool Contains(Range3D &r) {
		if (r.bounds[0][0] >= bounds[0][0] &&
			r.bounds[1][0] <= bounds[1][0] &&
			r.bounds[0][1] >= bounds[0][1] &&
			r.bounds[1][1] <= bounds[1][1] &&
			r.bounds[0][2] >= bounds[0][2] &&
			r.bounds[1][2] <= bounds[1][2])
			return true;
		else
			return false;
	}
};

#endif // __RANGE3D_H
