#ifndef PRIMSPHERE_H
#define PRIMSPHERE_H

#include <mesh/MMeshCreator.h>

#include <params/MIntParameter.h>
#include <params/MFloatParameter.h>

//----------------------------------------------------------------------------------------
//  MPrimitiveSphere
//----------------------------------------------------------------------------------------
class MPrimitiveSphere : public Aztec::MMeshCreator {
protected:
  Aztec::MFloatParameterPtr radiusParam;
  Aztec::MIntParameterPtr sectionsParam;
  Aztec::MIntParameterPtr vertSectionsParam;

  float lastRadius;
  int lastSections;
  int lastVertSections;
  Aztec::MMeshPtr m_LastMesh;

public:
  // Construction/Destruction
  MPrimitiveSphere();
  virtual ~MPrimitiveSphere();

  // MBaseObject methods
  MStr getClassName() {return MStr("MPrimitiveSphere");};
  Aztec::MBaseObjectPtr createNew();
  bool doUpdateObject();

protected:
  Aztec::MMeshPtr convertToMesh();
};




#endif


