#ifndef PRIMCSG_H
#define PRIMCSG_H

#include <mesh/MMeshCreator.h>
#include "MMesh.h"
#include "MMath.h"
#include "MEditableMesh.h"

#include <params/MChoiceParameter.h>

using namespace Aztec;

//----------------------------------------------------------------------------------------
//  MPrimitiveCSG
//----------------------------------------------------------------------------------------
class MPrimitiveCSG : public MMeshCreator {
public:
	// CSG Operations
	typedef enum { None, Union, Intersection, Difference1, Difference2 } CSGOp;

protected:
	CSGOp m_Op;
	MChoiceParameterPtr m_CSGOpParam;
	MShapeObjectPtr m_BaseShape1, m_BaseShape2;
	MEditableMeshPtr m_Mesh;

    MObjectParameterPtr m_InMeshParam1, m_InMeshParam2;
	// MButtonParameterObjectPtr m_BuildBtn;
	bool m_RebuildFlag;

	int determineCSGOp();
	MMeshPtr getChildMesh(MSceneObjectPtr sceneObj);
	void rebuildMesh();

public:
	// Construction/Destruction
	MPrimitiveCSG();
	virtual ~MPrimitiveCSG();
	
  // MBaseObject methods
	MStr getClassName() {return MStr("MPrimitiveCSG");};
	MBaseObjectPtr createNew();
  bool doUpdateObject();
protected:
	MMeshPtr convertToMesh();

};

#endif 
