#include "StdAfx.h"

#include <time.h>

#include <MThread.h>

int MThread::ThreadStack = THREADSTACKSIZE;

void threadCall(void *voidThread) {
  MThread *newThread = (MThread *)voidThread;
  newThread->main();
  delete newThread;
}


MThread::MThread()
{
  init();
}


MThread::~MThread()
{
  done();
}


int MThread::spawn() {
#ifdef WIN32
  threadID=_beginthread(threadCall,ThreadStack,this);    
  return threadID;
#else

  threadID=fork();
  if (threadID!=0) {                            
    delete this;                                
    return threadID;
  }                                           
  threadCall(this);                             
  _exit(0);                                     
#endif

}


void MThread::sleep(int milliseconds) {
#ifdef WIN32
  Sleep(milliseconds);
#else

  int now = time(NULL);
  do { ::yield(); } while (time(NULL)-now < (milliseconds/1000) );
#endif

}


int MThread::init() {
#ifndef WIN32
  struct sigaction act;
  pid_t  pid;

  act.sa_handler = sig_chld;
  sigemptyset(&act.sa_mask);
  act.sa_flags = SA_NOCLDSTOP;

  if (sigaction(SIGCHLD, &act, NULL) < 0) {
    fprintf(stderr, "sigaction failed\n");
    return 1;
  }
#endif


  return 0;
}


void sig_chld(int signo) {
#ifndef WIN32
  int status, child_val;

  if (waitpid(-1, &status, WNOHANG) < 0)  return;

  if (WIFEXITED(status))               
    child_val = WEXITSTATUS(status);  
#endif

}
