// ParticleSourceEditDlg.cpp: implementation of the CParticleAttributeSourceEditDlg class.
//
//////////////////////////////////////////////////////////////////////
#include "stdafx.h"
#include "resource.h"

#include <stdlib.h>

#include "dialogs/ParticleSourceEditDlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CParticleSourceEditDlg::CParticleSourceEditDlg() :
	CDomainEditDlg(),
	particle_rate(10.0f)
{

}

CParticleSourceEditDlg::~CParticleSourceEditDlg()
{

}

void CParticleSourceEditDlg::setEntriesFromParams(int startIndex, particleParamType &entries)
{
#if 0
	char buf[32];
	OutputDebugString("Params:\n");
	int j, numEntries = entries.size();
	for (j=0;j<numEntries;j++) {
		sprintf(buf, "   %f\n", entries[j]);
		OutputDebugString(buf);
	}
#endif

	int i = 0;
	// Pull the source specific parameters
	particle_rate = entries[i++];

	CDomainEditDlg::setEntriesFromParams(i, entries);

	// Put the member values into the edit controls
	setEditLayout(m_Domain);
}

void CParticleSourceEditDlg::getParamsFromEntries(particleParamType &params)
{
	char buf[64];

	// Get the source specific parameters
	GetDlgItemText(IDC_PARTICLE_EXTRA1_EDIT, buf, sizeof(buf));
	params.push_back((float)atof(buf));

	// Get the generic domain parameters
	CDomainEditDlg::getParamsFromEntries(params);
}

LRESULT CParticleSourceEditDlg::OnInitDialog(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled)
{
	CDomainEditDlg::OnInitDialog(uMsg, wParam, lParam, bHandled);

	::ShowWindow(GetDlgItem(IDC_SOURCE_EXTRA_GROUP), SW_SHOW);
	SetDlgItemText(IDC_SOURCE_EXTRA_GROUP, "Particle Rate");
	::ShowWindow(GetDlgItem(IDC_PARTICLE_EXTRA1_EDIT), SW_SHOW);

	return 0;
}

void CParticleSourceEditDlg::setEditLayout(PDomainEnum domain)
{
	CDomainEditDlg::setEditLayout(domain);

	char buf[32];
	SetDlgItemText(IDC_PARTICLE_EXTRA1_EDIT, _gcvt(particle_rate, 7, buf));
}
