#include "StdAfx.h"

#include <MSystemManager.h>
#include <ParticleActionParam.h>

#include <assert.h>

#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

namespace Aztec {

FloatArrayParam::FloatArrayParam(MPrimitiveParticle *particle, int index)
	: MParameterObjectImpl("param", "param", "param", NULL)

{
	mParticle = particle;
	mActionIndex = index;
}

FloatArrayParam::~FloatArrayParam()
{
}

MBaseObject* FloatArrayParam::getOwner() const
{
	return &*mParticle->getParamList();
}

void FloatArrayParam::setOwner(MBaseObject *newOwner)
{
}

int FloatArrayParam::getElementCount()
{
	return mParticle->m_ActionList[mActionIndex].m_params.size();
}

int FloatArrayParam::addElement()
{
	return 0;
}

void FloatArrayParam::removeElement(int index)
{
}

void FloatArrayParam::resize(int size)
{
}

MParameterObjectPtr FloatArrayParam::getElement(int index)
{
	return NULL;
}

bool FloatArrayParam::getElement(int index, float &value)
{
	value = mParticle->m_ActionList[mActionIndex].m_params[index];

	return true;
}

bool FloatArrayParam::setElement(int index, float value)
{
	mParticle->m_ActionList[mActionIndex].m_params[index] = value;

	return true;
}

int FloatArrayParam::getElementType() const
{
	return TYPE_FLOAT;
}

int FloatArrayParam::getDataMeaning() const
{
	return MEANING_ANY;
}

MParameterObjectPtr FloatArrayParam::createCopy()
{
	return NULL;
}

ParticleActionValue::ParticleActionValue(MPrimitiveParticle *particle, int index)
{
	mParticle = particle;
	mActionIndex = index;
}

int ParticleActionValue::getValue() {
	return mParticle->m_ActionList[mActionIndex].action;
}

// MParameterObject methods
int ParticleActionValue::getDataType() const {
	return TYPE_INTEGER;
}

int ParticleActionValue::getDataMeaning() const {
	return MEANING_ANY;
}

MStr ParticleActionValue::getShortName() const {
	return "action";
}

MStr ParticleActionValue::getLongName() const {
	return getShortName();
}

MStr ParticleActionValue::getFriendlyName() const {
	return getShortName();
}

MBaseObject* ParticleActionValue::getOwner() const {
	return mParticle;
}

void ParticleActionValue::setOwner(MBaseObject *newOwner) {
	assert(newOwner == mParticle);
}

bool ParticleActionValue::isInputParameter() {
	return true;
}

bool ParticleActionValue::getValueString(MStr &value) {
	value = intToStr(getValue());
	return true;
}

bool ParticleActionValue::getValueInteger(int &value) {
	value = getValue();
	return true;
}

bool ParticleActionValue::getValueFloat(float &value) {
	value = (float)getValue();
	return true;
}

bool ParticleActionValue::getValueBoolean(bool &value) {
	return false;
}

bool ParticleActionValue::getValueVector(MVector3 &value) {
	return false;
}

bool ParticleActionValue::setValueString(const MStr &value) {
	return setValueInteger(strToInt(value));
}

bool ParticleActionValue::setValueInteger(int value) {
	return false;
}

bool ParticleActionValue::setValueFloat(float value) {
	return setValueInteger((int)value);
}

bool ParticleActionValue::setValueBoolean(bool value) {
	return false;
}

bool ParticleActionValue::setValueVector(const MVector3 &value) {
	return false;
}

bool ParticleActionValue::setValueParameter(const MParameterObjectPtr &src) {
	int value;
	if (src->getValueInteger(value)) {
		return setValueInteger(value);
	}

	return false;
}

bool ParticleActionValue::createKeyAt(long time) {
	// Mesh triangle indeicies are not animatable.
	return false;
}

bool ParticleActionValue::setFromParameter(MParameterObjectPtr src) {
	int value;
	if (src->getValueInteger(value)) {
		return setValueInteger(value);
	}

	return false;
}

bool ParticleActionValue::isConnectable() {
	return false;
}

bool ParticleActionValue::isConnected() {
	return false;
}

bool ParticleActionValue::setInputParameter(const MParameterObjectPtr &input) {
	return false;
}

MParameterObjectPtr ParticleActionValue::getInputParameter() {
	return NULL;
}

MParameterObjectPtr ParticleActionValue::createCopy() {
	return new ParticleActionValue(mParticle, mActionIndex);
}

ParticleActionElement::ParticleActionElement(MPrimitiveParticle *particle, int index)
	: MParameterObjectImpl("action", "action", "action", NULL)
{
	mParticle = particle;
	mActionIndex = index;
}

ParticleActionElement::~ParticleActionElement()
{
}

int ParticleActionElement::getMemberCount()
{
	return 2;
}

MParameterObjectPtr ParticleActionElement::getMember(int index)
{
	if (index == 0) {
		// Return an integer representation of the action
		return new ParticleActionValue(mParticle, mActionIndex);
	} else if (index == 1) {
		// Return a float array of the parameters for the action
		return new FloatArrayParam(mParticle, mActionIndex);
	} else {
		return NULL;
	}
}

MStr ParticleActionElement::getMemberName(int index)
{
	if (index == 0) {
		return "action";
	} else if (index == 1) {
		return "params";
	} else {
		return "";
	}
}

int ParticleActionElement::getMemberIndex(const MStr &name)
{
	if (strcmp(name.c_str(), "action") == 0) {
		return 0;
	} else if (strcmp(name.c_str(), "params") == 0) {
		return 1;
	} else {
		return -1;
	}
}
int ParticleActionElement::getDataType() const
{
	return TYPE_AGGREGATE;
}

int ParticleActionElement::getDataMeaning() const
{
	return MEANING_ANY;
}

bool ParticleActionElement::getValueString(MStr &value)
{
	return false;
}

bool ParticleActionElement::getValueInteger(int &value)
{
	return false;
}

bool ParticleActionElement::getValueFloat(float &value)
{
	return false;
}

bool ParticleActionElement::getValueBoolean(bool &value)
{
	return false;
}

bool ParticleActionElement::getValueVector(MVector3 &value)
{
	return false;
}

bool ParticleActionElement::setValueString(const MStr &value)
{
	return false;
}

bool ParticleActionElement::setValueInteger(int value)
{
	return false;
}

bool ParticleActionElement::setValueFloat(float value)
{
	return false;
}

bool ParticleActionElement::setValueBoolean(bool value)
{
	return false;
}

bool ParticleActionElement::setValueVector(const MVector3 &value)
{
	return false;
}

bool ParticleActionElement::setValueParameter(const MParameterObjectPtr &value)
{
	return false;
}

MParameterObjectPtr ParticleActionElement::createCopy()
{
	// TBD: return something that can contain a copy
	return NULL;
}

ParticleActionParam::ParticleActionParam(MPrimitiveParticle *particle) :
	MParameterObjectImpl("actions", "actions", "actions", NULL), mParticle(particle)
{
}

ParticleActionParam::~ParticleActionParam() {
}

MBaseObject* ParticleActionParam::getOwner() const {
	return &*mParticle->getParamList();
}

void ParticleActionParam::setOwner(MBaseObject *newOwner)
{
	assert(newOwner == mParticle);
}

bool ParticleActionParam::isInputParameter()
{
	return true;
}

int ParticleActionParam::getElementCount()
{
	return mParticle->m_ActionList.size();
}

int ParticleActionParam::addElement()
{
	// TBD: Add an action to the list - perhaps a generic action, which is later
	// set to something more specific.
	return -1;
}

void ParticleActionParam::removeElement(int index)
{
	// TBD: Remove an action from the list
}

void ParticleActionParam::resize(int size)
{
	// TBD: resize the action list.
}

MParameterObjectPtr ParticleActionParam::getElement(int index)
{
	return new ParticleActionElement(mParticle, index);
}

bool ParticleActionParam::getElement(int index, MStr &value)
{
	return true;
}

bool ParticleActionParam::getElement(int index, MVector3 &value)
{
	return true;
}

bool ParticleActionParam::setElement(int index, const MStr &value)
{ 
	return false; 
}

bool ParticleActionParam::setElement(int index, const MVector3 &value)
{ 
	return false; 
}

int ParticleActionParam::getElementType() const
{
	// TBD: Probably should be type aggregate with one part of the aggregate being
	// the action type and the other part the parameters for the action (e.g.,
	// a color domain along with color vectors that define it.)
	return TYPE_ARRAY; 
}

// MParameterObject methodsfs
int ParticleActionParam::getDataMeaning() const
{ 
	return MEANING_ANY; 
}

bool ParticleActionParam::createKeyAt(long time)
{ 
	return false; 
}

MParameterObjectPtr ParticleActionParam::createCopy()
{
	// TODO: return something that can contain a copy
	return NULL;
}

}
