// ParticleColorEditDlg.h: interface for the CParticleColorEditDlg class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_PARTICLECOLOREDITDLG_H__2FC935CD_95B1_4E9A_883D_0B31BEDD6988__INCLUDED_)
#define AFX_PARTICLECOLOREDITDLG_H__2FC935CD_95B1_4E9A_883D_0B31BEDD6988__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "dialogs/ParticleActionDlgBase.h"

class CParticleColorEditDlg : public CParticleActionDlgImpl<CParticleColorEditDlg>
{
public:
	CParticleColorEditDlg(float r, float g, float b, float a);
	virtual ~CParticleColorEditDlg();

	void setEntriesFromParams(int startIndex, particleParamType &entries);
	void getParamsFromEntries(particleParamType &params);

	void setRed1(float ir) { r1 = ir; }
	float getRed1() { return r1; }
	void setGreen1(float ig) { g1 = ig; }
	float getGreen1() { return g1; }
	void setBlue1(float ib) { b1 = ib; }
	float getBlue1() { return b1; }

	int getIntRed1() { return (int)(255.0 * r1); }
	int getIntGreen1() { return (int)(255.0 * g1); }
	int getIntBlue1() { return (int)(255.0 * b1); }
	int getIntRed2() { return (int)(255.0 * r2); }
	int getIntGreen2() { return (int)(255.0 * g2); }
	int getIntBlue2() { return (int)(255.0 * b2); }
	int getIntRed3() { return (int)(255.0 * r3); }
	int getIntGreen3() { return (int)(255.0 * g3); }
	int getIntBlue3() { return (int)(255.0 * b3); }

	void setAlpha(float ia) { alpha = ia; }
	float getAlpha() { return alpha; }
	int getIntAlpha() { return (int)(255.0 * alpha); }

protected:
	PDomainEnum m_Domain;
	float alpha;
	float r1, g1, b1;
	float r2, g2, b2;
	float r3, g3, b3;

	COLORREF m_customColors[16];	// Save custom colors between calls to color dialog

	void setEditLayout(PDomainEnum domain);

public:
	enum { IDD = IDD_ACTION_EDIT_COLOR_DIALOG };

	BEGIN_MSG_MAP(CParticleColorEditDlg)
	   	MESSAGE_HANDLER(WM_INITDIALOG, OnInitDialog)
		COMMAND_HANDLER(IDC_CHOOSE_COLOR1_BUTTON, BN_CLICKED, OnBnClickedChooseColor1Button)
		COMMAND_HANDLER(IDC_CHOOSE_COLOR2_BUTTON, BN_CLICKED, OnBnClickedChooseColor2Button)
		COMMAND_HANDLER(IDC_CHOOSE_COLOR3_BUTTON, BN_CLICKED, OnBnClickedChooseColor3Button)
		COMMAND_HANDLER(IDC_COLOR_DOMAIN_COMBO, CBN_SELCHANGE, OnComboChange)

		MESSAGE_HANDLER(WM_DRAWITEM, OnDrawItem)
	END_MSG_MAP()

	LRESULT OnInitDialog(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	LRESULT OnBnClickedChooseColor1Button(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/);
	LRESULT OnBnClickedChooseColor2Button(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/);
	LRESULT OnBnClickedChooseColor3Button(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/);
	LRESULT OnDrawItem(UINT /*uMsg*/, WPARAM wParam, LPARAM lParam, BOOL& /*bHandled*/);
	LRESULT OnComboChange(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);
};

#endif // !defined(AFX_PARTICLECOLOREDITDLG_H__2FC935CD_95B1_4E9A_883D_0B31BEDD6988__INCLUDED_)
