#include <gui/MApplication.h>

#include <gui/MWindow.h>
#include <gui/MLabel.h>
#include <gui/MBorderLayout.h>
#include <gui/MFlowLayout.h>
#include <gui/MButton.h>
#include <gui/MTextField.h>
#include <gui/MTabbedContainer.h>

class HelloWorld : public Aztec::MApp {
public:

  static void makePane(const std::string &name, const Aztec::MContainerPtr &pane) {
    pane->setLayoutManager(new Aztec::MFlowLayout(2,2,2));


    for (int i = rand() % 5 + 2; i >= 0; --i) {
      pane->addComponent(new Aztec::MLabel(name));
      pane->addComponent(new Aztec::MTextField(15));
      pane->addComponent(new Aztec::MLabel(name));
      pane->addComponent(new Aztec::MTextField(5));
    }
  }

  bool initApp() {
    Aztec::MWindowPtr mainWindow = new Aztec::MWindow("Border Layout example");

    // we have to explicitly create top level windows. All other controls are auto created.
    if (!mainWindow->create()) {
      // if the window creation failed, bail out.
      return false;
    }

    mainWindow->setSize(500,500);

    // The layout manager takes care of the placement of components.
    mainWindow->setLayoutManager(new Aztec::MBorderLayout());


    Aztec::MContainerPtr container;

    container = new Aztec::MContainer();
    container->setBackgroundColour(Aztec::MColour(1.0, 1.0, 0.0));
    container->setLayoutManager(new Aztec::MBorderLayout(5,5));
    container->setMinimumSize(Aztec::MSize2D(64,64));
    mainWindow->addComponent(container, Aztec::MBorderLayout::SOUTH);
    container->addComponent(new Aztec::MButton("South"));

    Aztec::MTabbedContainerPtr tabbed = new Aztec::MTabbedContainer();
    mainWindow->addComponent(tabbed, Aztec::MBorderLayout::CENTRE);

    Aztec::MContainerPtr pane1 = tabbed->addPane("test");
    Aztec::MContainerPtr pane2 = tabbed->addPane("test 1");
    Aztec::MContainerPtr pane3 = tabbed->addPane("test 2");
    
    makePane("test", pane1);
    makePane("test 1", pane2);
    makePane("test 2", pane3);
    
//    container->setLayoutManager(new Aztec::MBorderLayout(5,5));
//    container->addComponent(new Aztec::MButton("Centre"));

    


    // Now display our main window.
    mainWindow->setVisible(true);

    // return true to indicate that eveything started up okay.
    return true;
  }

  void cleanup() {
  }

};


AZTEC_USE_APP(HelloWorld)