
#include <gui/MApplication.h>

#include <gui/MWindow.h>
#include <gui/MButton.h>
#include <gui/MTextField.h>
#include <gui/MBorderLayout.h>
#include <gui/MFlowLayout.h>


class HelloWorld : public Aztec::MApp {
public:

  bool initApp() {
    Aztec::MWindowPtr mainWindow = new Aztec::MWindow("Hello World");

    // we have to explicitly create top level windows. All other controls are auto created.
    if (!mainWindow->create()) {
      // if the window creation failed, bail out.
      return false;
    }

    mainWindow->setSize(400,400);

    // The layout manager takes care of the placement of components. See some 
    // other examples to see this in action.
    mainWindow->setLayoutManager(new Aztec::MBorderLayout());

    Aztec::MContainerPtr content = new Aztec::MContainer();
    content->setLayoutManager(new Aztec::MFlowLayout());
    mainWindow->addComponent(content, Aztec::MBorderLayout::CENTRE);

    // make a lot of buttons
    for (int i = 0; i < 20; ++i) {
      if (i % 2) {
        Aztec::MButtonPtr button = new Aztec::MButton();
        content->addComponent(button);
        button->setCaption("Hello World!");
      }
      else {
        Aztec::MTextFieldPtr textfield = new Aztec::MTextField();
        content->addComponent(textfield);
        textfield->setValue("AZTEc iS Teh kEwl!!!!!");
      }
    }

    output = new Aztec::MTextField();
    output->setValue("Program output goes here");
    mainWindow->addComponent(output, Aztec::MBorderLayout::SOUTH);


    // Now display our main window.
    mainWindow->setVisible(true);

    // return true to indicate that eveything started up okay.
    return true;
  }

  void cleanup() {
  }

  bool onKeyPressed(const Aztec::MKeyEvent &event) {
    char buf[1024];
    Aztec::MComponent *c = &*event.getComponent();
    const type_info &t = typeid(c);
    sprintf(buf, "Key '%c' (%i) Pressed on class '%s'", event.getChar(), event.getChar(), t.name() );
    output->setValue(buf);
    return true;
  }

  bool onKeyReleased(const Aztec::MKeyEvent &event) {
    char buf[1024];
    Aztec::MComponent *c = &*event.getComponent();
    const type_info &t = typeid(c);
    sprintf(buf, "Key '%c' (%i) Released on class '%s'", event.getChar(), event.getChar(), t.name() );
    output->setValue(buf);
    return true;
  }

  Aztec::MTextFieldPtr output;

};


AZTEC_USE_APP(HelloWorld)

