#ifndef SceneObjectPlugin_Header
#define SceneObjectPlugin_Header

#include <AztecGUIMParameterPlugin.h>
#include <SceneObjectDlg.h>
#include <MSceneObject.h>

class SceneObjectPlugin : public AztecGUI::MParameterPlugin {
public:
  SceneObjectPlugin();
  ~SceneObjectPlugin();

  // MParameterPlugin methods
  std::string getFriendlyName();
  bool isUIForObject(const Aztec::MBaseObjectPtr &obj);
  void createControls(HWND parentWnd, const Aztec::MBaseObjectPtr &object);
  void destroyControls();
  void cancelChanges();
  void updateGUIValues(const Aztec::MBaseObjectPtr &object);

private:
  Aztec::MSceneObjectPtr sceneObject;
  CSceneObjectDlg *dlg;

  typedef std::pair<CWnd*,AztecGUI::MParameterPluginPtr> CWndPluginPair;
  typedef std::vector<CWndPluginPair> CWndPluginList;
  CWndPluginList shapeObjWnds;
};



#endif