// UndoCfg.cpp : implementation file
//

#include <AztecMainPCH.h>
#include "AztecMain.h"

//#include "MdlGlobs.h"

#include "UndoCfg.h"
#include "MSystemManager.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CUndoConfigPage property page

IMPLEMENT_DYNCREATE(CUndoConfigPage, CPropertyPage)

CUndoConfigPage::CUndoConfigPage() : CPropertyPage(CUndoConfigPage::IDD)
{
  //{{AFX_DATA_INIT(CUndoConfigPage)
  //}}AFX_DATA_INIT
}

CUndoConfigPage::~CUndoConfigPage()
{
}

void CUndoConfigPage::DoDataExchange(CDataExchange* pDX)
{
  CPropertyPage::DoDataExchange(pDX);
  //{{AFX_DATA_MAP(CUndoConfigPage)
  DDX_Control(pDX, IDC_UNDOLEVELSEDIT, m_UndoLevelsEdit);
  DDX_Control(pDX, IDC_MAXUNDOSEDIT, m_MaxUndosEdit);
  DDX_Control(pDX, IDC_UNDOMODE_TAB, m_UndoModeTab);
  //}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CUndoConfigPage, CPropertyPage)
//{{AFX_MSG_MAP(CUndoConfigPage)
ON_NOTIFY(UDN_DELTAPOS, IDC_MAXUNDOSSPIN, OnDeltaposMaxundosspin)
ON_NOTIFY(TCN_SELCHANGE, IDC_UNDOMODE_TAB, OnSelchangeUndomodeTab)
ON_BN_CLICKED(IDC_LIMITUNDOSCHECK, OnLimitundoscheck)
//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CUndoConfigPage message handlers

BOOL CUndoConfigPage::OnInitDialog() 
{
  CPropertyPage::OnInitDialog();
  
  m_UndoModeTab.InsertItem(0, "Main");
  m_UndoModeTab.InsertItem(1, "Skins");
  m_UndoModeTab.InsertItem(2, "Painter");
  
  UpdateSpinEdits();
  
  return TRUE;  // return TRUE unless you set the focus to a control
  // EXCEPTION: OCX Property Pages should return FALSE
}

/*
class CUndoLimitInfo
{
public:
int   m_NodeCount;
int   m_MaxNodes,m_MinNodes,m_MaxSize;
bool  m_DeleteRedoOnAdd;
};
*/
void CUndoConfigPage::UpdateSpinEdits()
{
  MStr        Str;
  
  GetCurrentUndoMode();
  
  CButton  *LimitCheck;
  LimitCheck = (CButton*)GetDlgItem(IDC_LIMITUNDOSCHECK);
  
  if (!m_CurInfo->m_Limit)     // No max's set, therefore infinite
  {
    LimitCheck->SetCheck(0);
  }
  else
  {
    LimitCheck->SetCheck(1);
    
    if (!m_CurInfo->m_LimitMaxNodes)
    {
      m_MaxUndosEdit.SetWindowText("-");
    }
    else
    {
      Str.Format("%i", m_CurInfo->m_MaxNodes);
      m_MaxUndosEdit.SetWindowText(Str);
    }
    
  }
  
  Str.Format("%i", m_CurInfo->m_NodeCount);
  m_UndoLevelsEdit.SetWindowText(Str);
  
}

void CUndoConfigPage::OnDeltaposMinundosspin(NMHDR* pNMHDR, LRESULT* pResult) 
{
  NM_UPDOWN* pNMUpDown = (NM_UPDOWN*)pNMHDR;
  
  GetCurrentUndoMode();
  
  *pResult = 0;
}

void CUndoConfigPage::OnDeltaposMaxundosspin(NMHDR* pNMHDR, LRESULT* pResult) 
{
  NM_UPDOWN* pNMUpDown = (NM_UPDOWN*)pNMHDR;
  
  GetCurrentUndoMode();
  if (m_CurInfo->m_MaxNodes != -1)
  {
    m_CurInfo->m_MaxNodes -= pNMUpDown->iDelta;
    UpdateSpinEdits();
  }
  
  *pResult = 0;
}

void CUndoConfigPage::OnDeltaposMaxundosizespin(NMHDR* pNMHDR, LRESULT* pResult) 
{
  NM_UPDOWN* pNMUpDown = (NM_UPDOWN*)pNMHDR;
  
  
  *pResult = 0;
}

void CUndoConfigPage::GetCurrentUndoMode()
{
  m_CurInfo = NULL;
  if (m_UndoModeTab.GetCurSel() == 0)    // Main Undo m_CurInfo
  {
    m_CurInfo = &m_MainInfo;
  }
  if (m_UndoModeTab.GetCurSel() == 1)    // Skin Undo m_CurInfo
  {
    m_CurInfo = &m_SkinInfo;
  }
  if (m_UndoModeTab.GetCurSel() == 2)    // Paint Undo m_CurInfo
  {
    m_CurInfo = &m_PaintInfo;
  }
  ASSERT(m_CurInfo);   
}


void CUndoLimitInfo::GetFromUndoManager() {
  MUndoManagerPtr undoMan = Aztec::getSystemManager()->getUndoManager();

  m_MaxNodes = undoMan->getMaxUndos();
  
  m_NodeCount = undoMan->getNumUndoNodes();
  
  m_LimitMaxNodes = true;
  
  if (m_MaxNodes == -1) {
    m_LimitMaxNodes = false;
    m_MaxNodes = 15;
  }
  
  if (m_LimitMaxNodes) {
    m_Limit = true;
  } else {
    m_Limit = false;
  }
}

void CUndoLimitInfo::SetToUndoManager() {
  MUndoManagerPtr undoMan = Aztec::getSystemManager()->getUndoManager();
  
  if (m_LimitMaxNodes) {
    undoMan->setMaxUndos(m_MaxNodes);
  } else {
    undoMan->setMaxUndos(-1);
  }
}

void CUndoConfigPage::OnSelchangeUndomodeTab(NMHDR* pNMHDR, LRESULT* pResult) {
  UpdateSpinEdits();   
  
  *pResult = 0;
}

void CUndoConfigPage::OnLimitundoscheck() {
  GetCurrentUndoMode();
  
  m_CurInfo->m_Limit = !m_CurInfo->m_Limit;
  
  if (m_CurInfo->m_Limit)
  {
    m_CurInfo->m_LimitMaxNodes = true;
  }
  else
  {
    m_CurInfo->m_LimitMaxNodes = false;
  }
  
  UpdateSpinEdits();
}

void CUndoConfigPage::OnMinundoscheck() 
{
}

void CUndoConfigPage::OnMaxundosradio() 
{
  GetCurrentUndoMode();
  m_CurInfo->m_LimitMaxNodes = true;
  UpdateSpinEdits();
}

void CUndoConfigPage::OnMaxundosizeradio() 
{
}
