#include <AztecMainPCH.h>

#include <MSystemManager.h>
#include <params/MParameterFactory.h>


#include "RegClass.h"
#include "ProgSet.h"

#include "RegClass.h"

#include "keyval.h"
#include "IniFile.h"

#include "resource.h"
#include "ToolConfigDlg.h"
#include "MDLGlobs.h"

#include <io.h>
#include <fcntl.h>
#include <sys/stat.h>


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// Create a parameter object with a given key/value.  The type of the parameter
// is deduced (in a simple manner) from the string representation of "value".
MParameterObjectPtr paramFromString(const char *keyname, const char *value)
{
	CValueType result;
	int keyType = getValueType(value, &result);

	switch (keyType) {
	case KEYVAL_TYPE_INTEGER:
		{
      MIntParameterPtr res = MParameterFactory::createInteger(keyname, keyname, keyname);
      res->setValueInteger(result.ival);
      return res;
    }
    break;
  case KEYVAL_TYPE_FLOAT:
    {
      MFloatParameterPtr res = MParameterFactory::createFloat(keyname, keyname, keyname);
      res->setValueFloat(result.dval);
      return res;
    }
    break;
  case KEYVAL_TYPE_BOOLEAN:
    {
      MBooleanParameterPtr res = MParameterFactory::createBoolean(keyname, keyname, keyname);
      res->setValueInteger(result.ival);
      return res;
    }
    break;
  case KEYVAL_TYPE_STRING:
    {
      MStringParameterPtr res = MParameterFactory::createString(keyname, keyname, keyname);
      res->setValueString(result.sval);
      return res;
    }
		break;
	case KEYVAL_TYPE_UNKNOWN:
	default:
		return NULL;
	}

	return NULL;
}

//----------------------------------------------------------------------------------------
//  MProgramSettings
//----------------------------------------------------------------------------------------

MProgramSettings::MProgramSettings() {
  LoadDefaults();
}

MProgramSettings::~MProgramSettings() {
}


void MProgramSettings::LoadDefaults() {
  m_CFGFile = "Aztec.cfg";
  m_KEYFile = "Aztec.key";
  
  char drive[_MAX_DRIVE],dir[_MAX_DIR];
  char ExePath[256];
  
  ::GetModuleFileName(NULL, ExePath, 255);
  _splitpath(ExePath, drive,dir,NULL,NULL);
  
  m_EXEPath.Format("Exe path - %s%s\n", drive, dir);
  
  m_EXEPath = drive;
  m_EXEPath += dir;

  m_PrefsPath = m_EXEPath + "..\\..\\common\\Prefs\\";
  
  // Key combinations for actions
  m_PanOrbitKey.m_Alt = true;
  m_PanOrbitKey.m_Left = true;
  
  m_PanTrackKey.m_Alt = true;
  m_PanTrackKey.m_Mid = true;
  
  m_PanZoomKey.m_Alt = true;
  m_PanZoomKey.m_Mid = true;
  m_PanZoomKey.m_Left = true;
  
  m_ManipGrabKey.m_Mid = true;
  
  m_SelectKey.m_Left = true;
  
  m_ContextKey.m_Right = true;

  // Load tool settings from the ini file.
	CIniString iniPath(m_PrefsPath + "Tools/tools.ini");
	iniFile.SetPath(iniPath);
	iniFile.ReadFile();
}

int MProgramSettings::SaveToRegistry(char *RegPath) {
  MRegistry   Reg;
  
  if (!Reg.openKey(RegPath)) {
    return 0;
  }
  
  Reg.writeString("CFGFile", m_CFGFile);
  Reg.writeString("KeyFile", m_KEYFile);
  
  Reg.closeKey();
  
  return 1;
}

int MProgramSettings::LoadFromRegistry(char *RegPath) {
  MRegistry   Reg;
  
  if (!Reg.openKey(RegPath)) {
    return 0;
  }
  
  Reg.readString("CFGFile", m_CFGFile);
  Reg.readString("KeyFile", m_KEYFile);
  
  Reg.closeKey();
  
  return 1;
}

MParameterObjectPtr MProgramSettings::
GetToolParameter(const MStr &ToolName, const MStr &ParamName)
{
	CIniString iniTool(ToolName), iniParam(ParamName);
	CIniString paramStr = iniFile.GetValue(iniTool, iniParam);
	if (paramStr.c_str() != NULL) {
		return paramFromString(ParamName.c_str(), paramStr.c_str());
	}
	
	return NULL;
}

int MProgramSettings::SetToolParameter(const MStr &ToolName, const MStr &ParamName, const MStr &Value)
{
	return SetToolParameters(ToolName, &ParamName, &Value, 1);
}

int MProgramSettings::
SetToolParameters(const MStr &ToolName,	const MStr *ParamName,
				  const MStr *Value, int NumParams)
{
	for (int n=0;n<NumParams;n++) {
		CIniString toolName(ToolName), paramName(ParamName[n]), value(Value[n]);
		iniFile.SetValue(toolName, paramName, value);
	}
	iniFile.WriteFile();

	return 0;
}

int MProgramSettings::ShowToolParameterEditWindow(const MStr &ToolName) {
	CToolConfigDlg    *Dlg;
	Dlg = new CToolConfigDlg;
	
	Dlg->Create(IDD_TOOLCONFIG_DIALOG);
	Dlg->MoveWindow(10,100,200,300);
	
	Dlg->SetToolName(ToolName);
	
  CIniString valueName, value;

  iniFile.startSectionIteration(ToolName.c_str());
  while (iniFile.getNextSectionValue(valueName, value)) {
    MParameterObjectPtr Var = paramFromString(valueName.c_str(), value.c_str());
	}

	Dlg->ShowWindow(SW_SHOW);

	return 1;
}
