//---------------------------------------------------------------------------
#include <AztecMainPCH.h>

#include "MdlConst.h"

#include "KeyFuncView.h"
#include "MMath.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//----------------------------------------------------------------------------------------
//  MShiftState
//----------------------------------------------------------------------------------------

MShiftState::MShiftState() {
  m_Shift = false;
  m_Ctrl = false;
  m_Alt = false;
  m_Left = false;
  m_Right = false;
  m_Mid = false;
}

void MShiftState::SetFromFlags(UINT nFlags) {
  m_Ctrl = (nFlags & MK_CONTROL) > 0;
  m_Shift = (nFlags & MK_SHIFT) > 0;
  m_Left = (nFlags & MK_LBUTTON) > 0;
  m_Right = (nFlags & MK_RBUTTON) > 0;
  m_Mid = (nFlags & MK_MBUTTON) > 0;
  
  short r,l,m;
  r = GetAsyncKeyState(VK_RMENU);
  l = GetAsyncKeyState(VK_LMENU);
  m = GetAsyncKeyState(VK_MENU);
  
  if (r <0 || l < 0 || m < 0) {
    m_Alt = true;
  } else {
    m_Alt = false;
  }
}

UINT MShiftState::SetIntoFlags() {
  UINT  nFlags;
  nFlags = 0;
  
  if (m_Ctrl) nFlags &= MK_CONTROL;
  if (m_Shift) nFlags &= MK_SHIFT;
  if (m_Left) nFlags &= MK_LBUTTON;
  if (m_Mid) nFlags &= MK_MBUTTON;
  if (m_Right) nFlags &= MK_RBUTTON;
  
  return nFlags;
}

void MShiftState::ProcessMessage(UINT message, WPARAM wParam, LPARAM lParam) {
  switch (message)
  {
  case WM_LBUTTONDOWN:
    m_Left = true;
    break;
  case WM_LBUTTONUP:
    m_Left = false;
    break;
  case WM_RBUTTONDOWN:
    m_Right = true;
    break;
  case WM_RBUTTONUP:
    m_Right = false;
    break;
  case WM_MBUTTONDOWN:
    m_Mid = true;
    break;
  case WM_MBUTTONUP:
    m_Mid = false;
    break;
  }
}

void MShiftState::SetFromKeyState() {
  short r,l,m;
  r = GetAsyncKeyState(VK_RMENU);
  l = GetAsyncKeyState(VK_LMENU);
  m = GetAsyncKeyState(VK_MENU);
  
  if (r <0 || l < 0 || m < 0)
    m_Alt = true;
  else 
    m_Alt = false;
  
  r = GetKeyState(VK_CONTROL);
  if (r<0) {
    m_Ctrl = true;
  }
  else {
    m_Ctrl = false;
  }
  
  r = GetKeyState(VK_SHIFT);
  if (r<0) {
    m_Shift = true;
  } else {
    m_Shift = false;
  }
  
}

bool MShiftState::operator==(const MShiftState &RHS) {
  return (m_Shift == RHS.m_Shift && m_Ctrl == RHS.m_Ctrl && m_Alt == RHS.m_Alt && 
    m_Left == RHS.m_Left && m_Mid == RHS.m_Mid && m_Right == RHS.m_Right);
}

void MShiftState::ReadFromStream(MInputStream &stream) {
  MStr  str;
  
  str = stream.readString();
  
  m_Shift = m_Alt = m_Ctrl = false;
  m_Left = m_Mid = m_Right = false;
  
  if (str.findSubstring("nothing") != -1) {  }
  if (str.findSubstring("shift") != -1) m_Shift = true;
  if (str.findSubstring("ctrl") != -1) m_Ctrl = true;
  if (str.findSubstring("alt") != -1) m_Alt = true;
  if (str.findSubstring("left") != -1) m_Left = true;
  if (str.findSubstring("middle") != -1) m_Mid = true;
  if (str.findSubstring("right") != -1) m_Right = true;
  
}

void MShiftState::WriteToStream(MOutputStream &stream) {
  MStr  str;
  
  if (m_Shift == false && m_Ctrl == false && m_Alt == false &&
    m_Left == false && m_Right == false && m_Mid == false) {
    
    str = "nothing";
    
  } else {
    if (m_Shift) str += "+shift";
    if (m_Ctrl) str += "+ctrl";
    if (m_Alt) str += "+alt";
    if (m_Left) str += "+left";
    if (m_Mid) str += "+middle";
    if (m_Right) str += "+right";
  }
  
  stream.writeString(str);
}
