// MShelfManager.cpp: implementation of the MShelfManager class.
//
//////////////////////////////////////////////////////////////////////

#include <AztecMainPCH.h>
#include "AztecMain.h"
#include "MShelfManager.h"

#include <io.h>

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

MShelfManager::MShelfManager()
{
   m_Shelves = NULL;
   m_NumShelves = 0;
   m_TabControl = NULL;
}

MShelfManager::~MShelfManager()
{
   DeleteAllShelves();
   
}


void MShelfManager::SetTabControl(CAutoTabCtrl *TabCtrl)
{
   m_TabControl = TabCtrl;
}

CAutoTabCtrl* MShelfManager::GetTabControl()
{
   return m_TabControl;
}

int MShelfManager::AddShelves(const MStr &Filespec)
{
   int            hFind, Result, NumAdded;
   MStr           Path, Filename;
   _finddata_t    FindData;


   {
      char           Drive[_MAX_DRIVE], Dir[_MAX_DIR];

      _splitpath((LPCTSTR)Filespec, Drive, Dir, NULL,NULL);
      Path = Drive;
      Path += Dir;
   }

   NumAdded = 0;
   hFind = _findfirst((LPCTSTR)Filespec, &FindData);
   
   if (hFind != -1)
   {
      Result = 0;
      while (Result != -1)
      {
         Filename = Path + MStr(FindData.name);
         AddShelf(Filename);
         NumAdded++;
         Result = _findnext(hFind, &FindData);
      }

      _findclose(hFind);
   }

   return NumAdded;
}


int MShelfManager::AddShelf(const MStr &ShelfFilename)
{
   if (!m_TabControl)
      return 0;


   CShelfDlg   *NewShelf, **NewShelves;
   int         n;

   NewShelf = new CShelfDlg;
   m_TabControl->AddTab(".", NewShelf, IDD_EMPTYDIALOG);
   NewShelf->LoadFromFile(ShelfFilename);

   // Set the name of the tab
   {
      TCITEM      ItemInfo;
      char        Name[128];

      ItemInfo.mask = TCIF_TEXT;
      NewShelf->GetWindowText(Name, 128);
      ItemInfo.pszText = Name;

      m_TabControl->SetItem(m_TabControl->GetItemCount()-1, &ItemInfo);
   }

   NewShelves = new CShelfDlg*[m_NumShelves+1];
   for (n=0;n<m_NumShelves;n++)
      NewShelves[n] = m_Shelves[n];

   NewShelves[m_NumShelves] = NewShelf;

   if (m_Shelves)
      delete[] m_Shelves;

   m_Shelves = NewShelves;
   m_NumShelves++;

   return 1;
}

void MShelfManager::DeleteAllShelves()
{
   if (!m_TabControl)
      return;

   while (m_TabControl->GetItemCount() > 0)
   {
      CDialog     *Dlg;
      TCITEM      TabItem;
      char        Text[128];

      TabItem.mask = TCIF_PARAM | TCIF_TEXT;
      TabItem.pszText = Text;
      TabItem.cchTextMax = 128;
      m_TabControl->GetItem(0, &TabItem);
      Dlg = (CDialog*)TabItem.lParam;

      m_TabControl->DeleteItem(0);

   }

   if (m_Shelves != NULL) {
     for (int i = 0; i < m_NumShelves; ++i) {
       if (m_Shelves[i] != NULL) {
         m_Shelves[i]->DestroyWindow();
         delete m_Shelves[i];
       }
     }
      delete[] m_Shelves;
   }
   m_Shelves = NULL;
   m_NumShelves = 0;
}

