#include <AztecMainPCH.h>

#include "resource.h"

#include "KeyFuncMain.h"
#include "KeyFuncGeneral.h"

#include "MMesh.h"
#include "MCompleteTranslator.h"
#include "MStr.h"
#include "MUIManager.h"

#include "MDLMsgs.h"

#include "Colors.h"

#include "KeyCfgPg.h"   // The keyoard config page dialog class.
#include "ClrCfgPg.h"   // the coor configuration dlg class
#include "UndoCfg.h"    // The Undo config page dialog class
#include "ControlConfig.h" // The control config page class

#include "UndoGeneral.h"

#include "OpenGLWnd.h"
#include "SceneViewWnd.h"
#include "UVEditViewWnd.h"
#include "SegmentViewWnd.h"
#include "GraphViewWnd.h"
#include "ParameterViewWnd.h"
#include <views/ImageViewerView.h>
#include <views/RenderView.h>

#include "DlgGlobs.h"   // Global dialog variables.
#include "MDLGlobs.h"

#include "ToolClasses.h"

#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


MStr    LastModelDir, LastMeshDir;

void InitMainActionList(MActionListType *AL)
{
  g_SysMan->logOutput("Initialising Main Action List");
  
  //Main
  AL->Add("KFileNew", "File New","Main", KFileNew, g_MainDlg, ID_FILE_NEW);
  AL->Add("KFileOpen", "File Open","Main",KFileOpen, g_MainDlg, ID_FILE_OPEN);
  AL->Add("KFileSave", "File Save","Main",KFileSave, g_MainDlg, ID_FILE_SAVE);
  AL->Add("KFileSaveAs", "File Save As","Main",KFileSaveAs, g_MainDlg, ID_FILE_SAVEAS);
  AL->Add("KFileMerge", "File Merge","Main",KFileMerge, g_MainDlg, ID_FILE_MERGE);
  AL->Add("KFileImport", "File Import","Main", KFileImport, g_MainDlg, ID_FILE_IMPORT);
  AL->Add("KFileExport", "File Export","Main",KFileExport, g_MainDlg, ID_FILE_EXPORT);
  AL->Add("KFileExit", "File Exit","Main",KFileExit, g_MainDlg, ID_FILE_EXIT);
  AL->Add("KEditUndo", "Undo","Main",KEditUndo, g_MainDlg, ID_EDIT_UNDO);
  AL->Add("KEditRedo", "Redo","Main",KEditRedo, g_MainDlg, ID_EDIT_REDO);
  
  AL->Add("KEditSelectAll", "Select All","Main",KEditSelectAll, g_MainDlg, ID_EDIT_SELECTALL);
  AL->Add("KEditSelectNone", "Select None","Main",KEditSelectNone, g_MainDlg, ID_EDIT_SELECTNONE);
  AL->Add("KEditSelectInverse", "Select Inverse","Main",KEditSelectInverse, g_MainDlg, ID_EDIT_SELECTINVERSE);
  AL->Add("KEditSelectChildren", "Select Children", "Main", KEditSelectChildren, g_MainDlg, ID_EDIT_SELECTCHILDREN);
  
  AL->Add("KOptionsConfigure", "Configure","Main",KOptionsConfigure, g_MainDlg, ID_OPTIONS_CONFIGURE);
  AL->Add("KHelpContents", "Help Contents","Main",KHelpContents, g_MainDlg, ID_HELP_CONTENTS);
  AL->Add("KHelpKeyword", "Help Keyword Search","Main",KHelpKeyword, g_MainDlg, ID_HELP_KEYWORDSEARCH);
  AL->Add("KHelpAbout", "Help About","Main",KHelpAbout, g_MainDlg, ID_HELP_ABOUT);
  AL->Add("KToolCycle", "Cycle Tools","Main",KToolCycle);
  
  AL->Add("KEditPurgeUndoLists", "Purge Undo Lists", "Main", KEditPurgeUndoLists, g_MainDlg, ID_EDIT_PURGE_UNDOLISTS);
  
  AL->Add("KControlNextFrame", "Next Frame","Main",KControlNextFrame);
  AL->Add("KControlPrevFrame", "Previous Frame","Main",KControlPrevFrame);
  AL->Add("KControlPlayCamera", "Play Camera","Main",KControlPlayCamera);
  
  AL->Add("KControlHideSelected", "Hide Selected","Display",KControlHideSelected, g_MainDlg, ID_DISPLAY_HIDE_SELECTED);
  AL->Add("KControlHideUnSelected", "Hide Unselected","Display",KControlHideUnSelected, g_MainDlg, ID_DISPLAY_HIDE_UNSELECTED);
  AL->Add("KControlHideAll", "Hide All","Display",KControlHideAll, g_MainDlg, ID_DISPLAY_HIDE_ALL);
  AL->Add("KControlShowSelected", "Show Selected","Display",KControlShowSelected, g_MainDlg, ID_DISPLAY_SHOW_SELECTED) ;
  AL->Add("KControlShowUnSelected", "Show Unselected","Display",KControlHideUnSelected, g_MainDlg, ID_DISPLAY_SHOW_UNSELECTED);
  AL->Add("KControlShowAll", "Show All","Display",KControlShowAll, g_MainDlg, ID_DISPLAY_SHOW_ALL);
  
  AL->Add("KToolsConsoleWindow", "Show Console Window","Window",KToolsConsoleWindow, g_MainDlg, ID_TOOLS_MEMOWINDOW);
  AL->Add("KWindowSceneOutline", "Show Scene Outline", "Window", KWindowSceneOutline, g_MainDlg, ID_WINDOW_SCENEOUTLINE);
  AL->Add("KWindowUVEdit", "Show UV Edit Window", "Window", KWindowUVEdit, g_MainDlg, ID_WINDOW_UVEDIT);
  AL->Add("KWindowSegmentEdit", "Segment Editor Window", "Window", KWindowSegmentEdit, g_MainDlg, ID_WINDOW_SEGMENTEDITOR);
  AL->Add("KWindowGraphView", "Graph View Window", "Window", KWindowGraphView, g_MainDlg, ID_WINDOW_GRAPHEDITOR);
  AL->Add("KWindowParameterView", "Parameter View Window", "Window", KWindowParameterView, g_MainDlg, ID_WINDOW_PARAMETERVIEW);
  AL->Add("KWindowImageViewer", "Image View Window", "Window", KWindowImageViewer, g_MainDlg, ID_WINDOW_IMAGEVIEWER);
  AL->Add("KWindowRenderView", "Render View", "Window", KWindowRenderView, g_MainDlg, ID_WINDOW_RENDERVIEW);
}

// file menu
int KFileNew()
{
  //	if (g_ChangesMade)
  {
   	int MBRes;
    MBRes = MessageBox(NULL, "Do you wish to save your changes?","Save Changes",MB_YESNOCANCEL | MB_TASKMODAL);
    
    if (MBRes == IDCANCEL)
      return 0;
    if (MBRes == IDYES)
      if (KFileSaveAs() == 0)
        return 0;
  }
  
  g_Scene->clearScene();
  g_Scene->setTime(0);

  Aztec::getSystemManager()->getUndoManager()->clearUndoInfo();
  
  g_CurFileName = "Untitled";
  
  ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
  ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATECHANNELBAR, 0, 0);
  ::SendMessage(g_MainDlg->m_hWnd, MM_FILENAMECHANGED, 0, 0);
  
  return 1;
}


int KFileOpen() {
  //	if (g_ChangesMade)
  {
   	int MBRes;
    MBRes = MessageBox(NULL, "Do you wish to save your changes?","Save Changes",MB_YESNOCANCEL | MB_TASKMODAL);
    
    if (MBRes == IDCANCEL)
      return 0;
    if (MBRes == IDYES)
      if (KFileSaveAs() == 0)
        return 0;
  }
  
  MCompleteTranslator trans;   
  std::string filter;
  
  filter = trans.getFilterDescription() + " (" + trans.getFilter() + ")|" + trans.getFilter() + "||";
  
  CFileDialog Dlg(TRUE, "", NULL, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, filter.c_str());
  
  Dlg.m_ofn.lpstrInitialDir = (LPCTSTR)LastModelDir;
  
  if (Dlg.DoModal() == IDCANCEL)
    return 0;

  Aztec::getSystemManager()->getUndoManager()->clearUndoInfo();
  
  __int64              StartTime, EndTime, DiffTime, Freq;
  
  // Start timing operation.
  QueryPerformanceCounter((LARGE_INTEGER*)&StartTime);
  
  if (trans.importFile((LPCTSTR)Dlg.GetPathName(), g_Scene))
  {
	   g_CurFileName = Dlg.GetPathName();
     
     if (g_MainDlg)
       SendMessage(g_MainDlg->m_hWnd, MM_FILENAMECHANGED,0,0);
     
     g_MainDlg->AddToMRUList(g_CurFileName);
  }
  else
    g_SysMan->logOutput("Translator Could not load file %s.", (LPCTSTR)Dlg.GetPathName());
  
  QueryPerformanceCounter((LARGE_INTEGER*)&EndTime);
  QueryPerformanceFrequency((LARGE_INTEGER*)&Freq);
  
  DiffTime = (EndTime - StartTime);
  double Time = (double)DiffTime / Freq;
  
  g_SysMan->logOutput("Reading of Scene to %.2f seconds to complete.", Time);
  
  ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
  ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATECHANNELBAR, 0, 0);
  
  return 1;
}

int KFileSave()
{
  KFileSaveAs();      
  return 1;
}

int KFileSaveAs()
{
  MCompleteTranslator trans;   
  std::string filter;
  
  filter = trans.getFilterDescription() + " (" + trans.getFilter() + ")|" + trans.getFilter() + "||";
  
  CFileDialog Dlg(FALSE, "", NULL, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, filter.c_str());
  
  Dlg.m_ofn.lpstrInitialDir = (LPCTSTR)LastModelDir;
  
  if (Dlg.DoModal() == IDCANCEL)
    return 0;
  
  if (trans.exportFile((LPCTSTR)Dlg.GetPathName(), g_Scene)) {
    {
      char Drive[4], Dir[265];
      _splitpath((LPCTSTR)Dlg.GetPathName(), Drive, Dir,NULL,NULL);
      LastModelDir = MStr(Drive) + MStr(Dir);
    }
    
	   g_CurFileName = Dlg.GetPathName();
     
     if (g_MainDlg)
       SendMessage(g_MainDlg->m_hWnd, MM_FILENAMECHANGED,0,0);
     
     g_MainDlg->AddToMRUList(g_CurFileName);
  }
  
  g_ChangesMade = 0;
  
  return 1;
}

int KFileMerge() {
  if (g_MainDlg)
    g_MainDlg->SendMessage(WM_COMMAND, ID_FILE_MERGE, 0);
  return 1;
}

int KFileImport()
{  
  CFileDialog       Dlg(TRUE, "", NULL, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT |OFN_ALLOWMULTISELECT , "");
  MStr              Filter, Title;
  int               Res;
  MSceneTranslatorPtr Trans;
  
  Filter = g_SysMan->createSceneTranslatorFilterString();
  Filter.Replace('|', '\x0');
  Title = "Import";
  
  Dlg.m_ofn.lpstrTitle = (LPCTSTR)Title;
  Dlg.m_ofn.lpstrFilter = (LPCTSTR)Filter;
  
  if (Dlg.DoModal() == IDCANCEL)
    return 0;
  
  g_SysMan->getTranslatorFromIndex(Dlg.m_ofn.nFilterIndex, Trans);
  
  
  {
    POSITION    Pos;
    
    Pos = Dlg.GetStartPosition();
    
    while (Pos)
    {
      CString  Str;
      Str = Dlg.GetNextPathName(Pos);
      
      // If trans was NULL, then we check each translator against each file to see if it can be used
      if (Trans == NULL)
      {
        MSceneTranslatorPtr SceneTrans;
        
        SceneTrans = g_SysMan->getPluginManager()->getSceneTranslatorThatImports((LPCTSTR)Str);
        
        // If SceneTrans is NULL, then no importers are available for that file
        if (SceneTrans == NULL) {
          g_SysMan->logOutput("No suitable Translator could be found for '%s'.", (LPCTSTR)Str);
          continue;
        }
        Res = SceneTrans->importFile((LPCTSTR)Str, g_Scene);
      } else {
        Res = Trans->importFile((LPCTSTR)Str, g_Scene);
      }
      
      if (!Res) {
        g_SysMan->logOutput("Translator Could not import file '%s'.", (LPCTSTR)Str);
      } else {
        g_SysMan->logOutput("Translator imported '%s' successfully.", (LPCTSTR)Str);
      }
    }
  }
  
  ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
  ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATECHANNELBAR, 0, 0);
  
  return Res;
}

int KFileExport()
{
  CFileDialog       Dlg(FALSE, "", NULL, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, "");
  MStr           Filter;
  int               Res;
  MSceneTranslatorPtr Trans;
  
  Filter = g_SysMan->createSceneTranslatorFilterString(false);
  
  Filter.Replace('|', '\x0');
  Dlg.m_ofn.lpstrFilter = (LPCTSTR)Filter;
  if (Dlg.DoModal() == IDCANCEL)
    return 0;
  
  g_SysMan->getTranslatorFromIndex(Dlg.m_ofn.nFilterIndex, Trans, false);

  // if we have no translator, then we try to match the flename to a translator
  if (Trans == NULL) {
    Trans = g_SysMan->getPluginManager()->getSceneTranslatorThatExports((LPCTSTR)Dlg.GetPathName());
  }

  // if we have a translator, then export it.
  if (Trans != NULL) {
    Res = Trans->exportFile((LPCTSTR)Dlg.GetPathName(), g_Scene);
  } else {
    g_SysMan->logOutput("Could not find the appropriate exporter for file '%s'", (LPCTSTR)Dlg.GetPathName());
    Res = 0;
  }
  
  return Res;
}




int KFileExit()
{
  // Ask the user if they wish to save their work
  int      Result;
  static int  Closing = 0;
  
  if (Closing)
    return 1;
  
  Closing = 1;
  
  Result = ::MessageBox(g_MainDlg->m_hWnd, "Do you wish to save your changes?", "Save Changes", MB_YESNOCANCEL);
  
  if (Result == IDCANCEL)
  {
    Closing = 0;
    return 0;
  }
  
  if (Result == IDYES)
  {
    KFileSave();
  }
  
  if (!g_Closing)
    PostMessage(g_MainDlg->m_hWnd, WM_CLOSE, 0, 0);
  
  return 1;
}

int KFileOpenMRU(int Number)
{
  if (Number < 0 || Number > 5)
    return 0;
  
  if (g_ChangesMade) {
   	int MBRes;
    MBRes = MessageBox(NULL, "Do you wish to save your changes?","Save Changes",MB_YESNOCANCEL | MB_TASKMODAL);
    
    if (MBRes == IDCANCEL) {
      return 0;
    }
    
    if (MBRes == IDYES) {
      if (KFileSaveAs() == 0) {
        return 0;
      }
    }
  }
  
  MCompleteTranslator     Trans;   
  MStr                    Filename;
  
  Filename = g_MRUList[Number];
  
  __int64              StartTime, EndTime, DiffTime, Freq;
  
  // Start timing operation.
  QueryPerformanceCounter((LARGE_INTEGER*)&StartTime);
  
  if (Trans.importFile((LPCTSTR)Filename, g_Scene))
  {
	   g_CurFileName = Filename;
     
     if (g_MainDlg != NULL)
       SendMessage(g_MainDlg->m_hWnd, MM_FILENAMECHANGED,0,0);
     
     g_MainDlg->AddToMRUList(g_CurFileName);
  }
  else
  {
    g_SysMan->logOutput("Translator Could not load file %s.", (LPCTSTR)Filename);
    return 0;
  }
  
  QueryPerformanceCounter((LARGE_INTEGER*)&EndTime);
  QueryPerformanceFrequency((LARGE_INTEGER*)&Freq);
  
  DiffTime = (EndTime - StartTime);
  double Time = (double)DiffTime / Freq;
  
  g_SysMan->logOutput("Reading of Scene to %.2f seconds to complete.", Time);
  
  ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
  ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATECHANNELBAR, 0, 0);
  
  return 1;
}



int KEditSelectAll() {
  // Check to see if we are in a UV edit window, and if so, deselect the vertices, rather than objects.
  if (g_CurView->getClassName() == "CUVEditViewWnd") {
    MSceneObjectPtr Obj;
    
    Obj = AZTEC_CAST(MSceneObject, g_Scene->getSelectedObjectList()->getTail());
    
    if (Obj != NULL)
    {
      MMeshPtr Mesh = AZTEC_CAST(MMesh, Obj->getShapeObject()->convertToMesh());
      if (Mesh != NULL) {
        MMeshPtr TextureMesh;
        
        Mesh = AZTEC_CAST(MMesh, Obj);
        TextureMesh = Mesh->getTextureMesh();
        
        if (TextureMesh != NULL) {
          TextureMesh->setVertexFlags(VERTEX_SELECTED);
        }
      }
    }
  } else {
    MBaseObjectPtr Obj;
    
    g_Scene->getObjectList()->beginIteration();
    
    while ((Obj = g_Scene->getObjectList()->getNext()) != NULL) {
      Obj->setFlag(OBJECTFLAG_SELECTED);
    }
    g_Scene->getObjectList()->endIteration();
  }
  
  KEditPurgeUndoLists();
  
  ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
  ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATECHANNELBAR, 0, 0);
  
  return 1;
}

int KEditSelectNone() {
  // Check to see if we are in a UV edit window, and if so, deselect the vertices, rather than objects.
  if (g_CurView->getClassName() == "CUVEditViewWnd") {
    MBaseObjectPtr Obj;
    
    Obj = g_Scene->getSelectedObjectList()->getTail();
    
    if (Obj != NULL) {
      if (Obj->getClassName() == "MMesh" || Obj->getClassName() == "MAnimMesh") {
        MMeshPtr Mesh;
        MEditableMeshPtr TextureMesh;
        
        Mesh = AZTEC_CAST(MMesh, Obj);
        TextureMesh = AZTEC_CAST(MEditableMesh, Mesh->getTextureMesh());
        
        if (TextureMesh != NULL)
        {
          if (TextureMesh->isInComponentMode(MComponentisedObject::POINT_TYPE)) {
            TextureMesh->unsetVertexFlags(VERTEX_SELECTED);
          }
          if (TextureMesh->isInComponentMode(MComponentisedObject::FACET_TYPE)) {
            for (int nTri = TextureMesh->getNumTris()-1; nTri >= 0; nTri --) {
              TextureMesh->unsetTriangleFlag(nTri, TRIANGLE_SELECTED);
            }
          }
          if (TextureMesh->isInComponentMode(MComponentisedObject::EDGE_TYPE)) {
            for (int edgeIndex = TextureMesh->getComponentCount(MComponentisedObject::EDGE_TYPE); 
                 edgeIndex >= 0; 
                 edgeIndex--)
            {
              TextureMesh->flagComponent(MComponentisedObject::EDGE_TYPE, edgeIndex, EDGE_SELECTED, MComponentisedObject::atUnset); 
            }
          }
          
        }
      }
    }
  } else {
    g_Scene->selectNone();
  }
  
  
  ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
  ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATECHANNELBAR, 0, 0);
  
  
  return 1;
}

int KEditSelectInverse()
{
  // Check to see if we are in a UV edit window, and if so, deselect the vertices, rather than objects.
  if (g_CurView->getClassName() == "CUVEditViewWnd")
  {
    MSceneObjectPtr Obj;
    
    Obj = AZTEC_CAST(MSceneObject, g_Scene->getSelectedObjectList()->getTail());
    
    if (Obj != NULL)
    {
      MMeshPtr Mesh = AZTEC_CAST(MMesh, Obj->getShapeObject()->convertToMesh());
      if (Mesh != NULL) {
        MEditableMeshPtr TextureMesh;
        
        Mesh = AZTEC_CAST(MMesh, Obj);
        TextureMesh = AZTEC_CAST(MEditableMesh, Mesh->getTextureMesh());
        
        if (TextureMesh != NULL) {
          
          if (TextureMesh->isInComponentMode(MComponentisedObject::POINT_TYPE)) {
            for (int nVert = TextureMesh->getNumVerts(); nVert >= 0; nVert --) {
              if (TextureMesh->isVertexFlagged(nVert, VERTEX_SELECTED)) {
                TextureMesh->unsetVertexFlag(nVert, VERTEX_SELECTED);
              } else {
                TextureMesh->setVertexFlag(nVert, VERTEX_SELECTED);
              }
            }
          } else if (TextureMesh->isInComponentMode(MComponentisedObject::FACET_TYPE)) {
            for (int nTri = TextureMesh->getNumTris(); nTri >= 0; nTri --) {
              if (TextureMesh->isTriangleFlagged(nTri, TRIANGLE_SELECTED)) {
                TextureMesh->unsetTriangleFlag(nTri, TRIANGLE_SELECTED);
              } else {
                TextureMesh->setTriangleFlag(nTri, TRIANGLE_SELECTED);
              }
            }
          }
          else if (TextureMesh->isInComponentMode(MComponentisedObject::EDGE_TYPE)) {
            for (int nTri = TextureMesh->getNumTris(); nTri >= 0; nTri --) {
              TextureMesh->toggleTriangleEdgeFlag(nTri, 0, EDGE_SELECTED);
              TextureMesh->toggleTriangleEdgeFlag(nTri, 1, EDGE_SELECTED);
              TextureMesh->toggleTriangleEdgeFlag(nTri, 2, EDGE_SELECTED);
            }
          }
        }
      }
    }
  }
  else
  {
    MBaseObjectPtr Obj;
    
    g_Scene->getObjectList()->beginIteration();
    while (( Obj = g_Scene->getObjectList()->getNext() ) != NULL )
    {
      if (Obj->isFlagged(OBJECTFLAG_SELECTED))
        Obj->unsetFlag(OBJECTFLAG_SELECTED);
      else
        Obj->setFlag(OBJECTFLAG_SELECTED);
    }
    g_Scene->getObjectList()->endIteration();
    
  }
  
  
  ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
  ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATECHANNELBAR, 0, 0);
  
  return 1;
}

int KEditSelectChildren()
{
  MBaseObjectPtr Obj;
  MTreeObjectNodePtr ObjNode;
  
  g_Scene->getObjectList()->beginIteration();;
  
  while (( Obj = g_Scene->getObjectList()->getNext() ) != NULL ) {
    ObjNode = g_Scene->getObjectList()->getCurrentNode();
    if (ObjNode->isChildOfFlagged(OBJECTFLAG_SELECTED)) {
      if (!Obj->isFlagged(OBJECTFLAG_SELECTED)) {
        Obj->setFlag(OBJECTFLAG_SELECTED);
        g_Scene->getSelectedObjectList()->addHead(Obj);
      }
    }
  }
  g_Scene->getObjectList()->endIteration();
  
  KEditPurgeUndoLists();
  
  ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
  ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATECHANNELBAR, 0, 0);
  
  return 1;
}


int KEditUndo() {
  Aztec::getSystemManager()->getUndoManager()->undo();
  g_Scene->setTime(g_Scene->getTime());
  g_Scene->updateObject(NULL);
  ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
  ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATECHANNELBAR, 0, 0);
  return 1;
}


int KEditRedo() {
  Aztec::getSystemManager()->getUndoManager()->redo();
  g_Scene->updateObject(NULL);
  ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
  ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATECHANNELBAR, 0, 0);
  
  return 1;
}


// View Menu

int KView3DEditor()
{
  if (g_MainDlg)
  {
    g_MainDlg->ShowWindow(SW_SHOW);
    g_MainDlg->SetWindowPos(&CWnd::wndTop , 0,0,0,0, SWP_NOMOVE | SWP_NOSIZE);
  }
  return 1;
}


// options menu

int KOptionsConfigure()
{
  CPropertySheet    Sheet;
  CKeyConfigPage    KeyConfigPage;
  CColorConfigPage  ColorConfigPage;
  CUndoConfigPage   UndoConfigPage;
  CControlConfig    ControlPage;
  
  int               Result;
  COLORREF          *NewColors, *OldColors;
  
  NewColors = new COLORREF[NUM_COLORS];
  OldColors = new COLORREF[NUM_COLORS];
  
  for (int i=0;i<NUM_COLORS;i++)
  {
    NewColors[i] = *COLORS[i];
    OldColors[i] = *COLORS[i];
  }
  
  ColorConfigPage.SetOldNewColors(OldColors, NewColors);   
  
  KeyConfigPage.m_KeyListCopy = g_KeyList;
  KeyConfigPage.m_GlobActionList = &g_ActionList;
  
  UndoConfigPage.m_MainInfo.GetFromUndoManager();
  
  ControlPage.m_PanOrbitKey = g_ProgSet.m_PanOrbitKey;
  ControlPage.m_ManipGrabKey = g_ProgSet.m_ManipGrabKey;
  ControlPage.m_PanTrackKey = g_ProgSet.m_PanTrackKey;
  ControlPage.m_PanZoomKey = g_ProgSet.m_PanZoomKey;
  
  Sheet.AddPage(&UndoConfigPage);
  Sheet.AddPage(&KeyConfigPage);
  Sheet.AddPage(&ColorConfigPage);
  Sheet.AddPage(&ControlPage);
  
  Sheet.SetTitle("Configuration");
  Result = Sheet.DoModal();
  
  if (Result == IDOK)     // User clicked ok, apply the changes.
  {
    g_KeyList = KeyConfigPage.m_KeyListCopy;
    g_KeyList.UpdateAllMenus();
    
    for (int i=0;i<NUM_COLORS;i++)
    {
      *COLORS[i] = NewColors[i];
    }
    
    UndoConfigPage.m_MainInfo.SetToUndoManager();
    
    g_ProgSet.m_PanOrbitKey = ControlPage.m_PanOrbitKey;
    g_ProgSet.m_ManipGrabKey = ControlPage.m_ManipGrabKey;
    g_ProgSet.m_PanTrackKey = ControlPage.m_PanTrackKey;
    g_ProgSet.m_PanZoomKey = ControlPage.m_PanZoomKey;
    
    g_MainDlg->SaveConfigToReg();
  }
  
  if (NewColors)
    delete[] NewColors;
  if (OldColors)
    delete[] OldColors;
  
  if (g_MainDlg)
    SendMessage(g_MainDlg->m_hWnd, MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
  
  
  return 1;
}


// Tools Menu



int KToolsConsoleWindow()
{
  if (g_MainDlg)
  {
    g_MainDlg->m_ConsoleDlg.ShowWindow(SW_SHOW);
    g_MainDlg->m_ConsoleDlg.SetWindowPos(&CWnd::wndTop , 50,300,0,0, SWP_NOSIZE);
    //      g_MainDlg->m_ConsoleDlg.SetWindowPos(&CWnd::wndTop , 0,0,0,0, SWP_NOMOVE | SWP_NOSIZE);
  }
  
  return 1;
}

int KToolsOutputBoundingBox()
{
  return 1;
}


// Help Menu

int KHelpContents()
{
  //g_MainDlg->Contents->Click();
  return 1;
}

int KHelpKeyword()
{
  //g_MainDlg->KeywordSearch->Click();
  return 1;
  
}

int KHelpAbout()
{
  //g_MainDlg->About->Click();
  return 1;
}


// Bottom Panel Commands


int KToolCycle()
{
  if (g_ToolMan.GetTool()->Is("KToolSelect"))
    KToolMove();
  else
    if (g_ToolMan.GetTool()->Is("KToolMove"))
      KToolRotate();
    else
      if (g_ToolMan.GetTool()->Is("KToolRotate"))
        KToolScale();
      else
        if (g_ToolMan.GetTool()->Is("KToolScale"))
          KToolSelect();
        else 
          return 0;      
        
        return 1;
}

// view control
int KControlNextFrame()
{
  g_Scene->setTime(g_Scene->getTime()+120);
  
  ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
  ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATECHANNELBAR, 0, 0);
  
  return 1;
}

int KControlPrevFrame() {
  g_Scene->setTime(g_Scene->getTime()-120);
  
  ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
  ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATECHANNELBAR, 0, 0);
  
  return 1;
}

int KControlLastFrame()
{
    
  return 1;
}

int KControlFirstFrame()
{
  
  return 1;
}


int KControlPlayCamera()
{
  g_Playing = !g_Playing;

  // Toggle play/pause button image
  if (g_Playing)
  {
    g_MainDlg->m_BottomToolDlg.m_PlayBut.SetImage(g_ProgSet.m_PrefsPath + "Buttons\\Pause.bmp");

    // Change the tooltip
    MAction*    Action = g_KeyList.FindAction("KControlPlayCamera", "Main");
    if (Action != NULL) Action->m_DisplayName = "Pause Camera";
  }
  else
  {
    g_MainDlg->m_BottomToolDlg.m_PlayBut.SetImage(g_ProgSet.m_PrefsPath + "Buttons\\Play.bmp");
      
    // Change the tooltip
    MAction*    Action = g_KeyList.FindAction("KControlPlayCamera", "Main");
    if (Action != NULL) Action->m_DisplayName = "Play Camera";
  }

  return 1;
}

int KControlHideSelected() {
  MBaseObjectTreePtr Objects;
  MBaseObjectPtr Obj;
  
  Objects = g_Scene->getObjectList();
  
  Objects->beginIteration();
  while (( Obj = Objects->getNext() ) != NULL ) {
    // depending on what mode we are in depends on what to so.
    if (Aztec::MUIManager::getComponentMode() == Aztec::MComponentisedObject::OBJECT_TYPE) {
      if (Obj->isFlagged(OBJECTFLAG_SELECTED)) {
        Obj->unsetFlag(OBJECTFLAG_VISIBLE);
      }
    } else {
      
      if (Obj->isFlagged(OBJECTFLAG_SELECTED)) {
        MSceneObjectPtr sceneObj = AZTEC_CAST(MSceneObject, Obj);
        if (sceneObj == NULL) {
          continue;
        }
        MComponentisedObjectPtr compObj = sceneObj->getComponentObject();

        if (compObj == NULL) {
          continue;
        }

        if (Aztec::MUIManager::getComponentMode() == Aztec::MComponentisedObject::EDGE_TYPE) {
          for (int n = 0; n < compObj->getComponentCount(MComponentisedObject::EDGE_TYPE); ++n) {
            if (compObj->isComponentFlagged(MComponentisedObject::EDGE_TYPE, n)) {
              compObj->flagComponent(MComponentisedObject::EDGE_TYPE, n, EDGE_VISIBLE, MComponentisedObject::atUnset);
            }
          }
        }
      }      
    }
  }
  Objects->endIteration();
  
  ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
  
  return 1;
}

int KControlHideUnSelected()
{
  MBaseObjectTreePtr Objects;
  MBaseObjectPtr Obj;
  
  Objects = g_Scene->getObjectList();
  
  Objects->beginIteration();
  while (( Obj = Objects->getNext() ) != NULL )
  {
    if (!Obj->isFlagged(OBJECTFLAG_SELECTED))
      Obj->unsetFlag(OBJECTFLAG_VISIBLE);
  }
  Objects->endIteration();
  
  ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
  
  return 1;
}

int KControlHideAll()
{
  MBaseObjectTreePtr Objects;
  MBaseObjectPtr Obj;
  
  Objects = g_Scene->getObjectList();
  
  Objects->beginIteration();
  while (( Obj = Objects->getNext() ) != NULL )
  {
    Obj->unsetFlag(OBJECTFLAG_VISIBLE);
  }
  Objects->endIteration();
  
  ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
  
  return 1;
}

int KControlShowSelected()
{
  MBaseObjectTreePtr Objects;
  MBaseObjectPtr Obj;
  
  Objects = g_Scene->getObjectList();
  
  Objects->beginIteration();
  while (( Obj = Objects->getNext() ) != NULL ) {
    // depending on what mode we are in depends on what to so.
    if (Aztec::MUIManager::getComponentMode() == Aztec::MComponentisedObject::OBJECT_TYPE) {
      if (Obj->isFlagged(OBJECTFLAG_SELECTED)) {
        Obj->setFlag(OBJECTFLAG_VISIBLE);
      }
    } else {
      
      if (Obj->isFlagged(OBJECTFLAG_SELECTED)) {
        MSceneObjectPtr sceneObj = AZTEC_CAST(MSceneObject, Obj);
        if (sceneObj == NULL) {
          continue;
        }
        MComponentisedObjectPtr compObj = sceneObj->getComponentObject();

        if (compObj == NULL) {
          continue;
        }

        if (Aztec::MUIManager::getComponentMode() == Aztec::MComponentisedObject::EDGE_TYPE) {
          for (int n = 0; n < compObj->getComponentCount(MComponentisedObject::EDGE_TYPE); ++n) {
            if (compObj->isComponentFlagged(MComponentisedObject::EDGE_TYPE, n)) {
              compObj->flagComponent(MComponentisedObject::EDGE_TYPE, n, EDGE_VISIBLE, MComponentisedObject::atSet);
            }
          }
        }
      }      
    }
  }
  Objects->endIteration();
  
  ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
  
  return 1;
}

int KControlShowUnSelected()
{
  MBaseObjectTreePtr Objects;
  MBaseObjectPtr Obj;
  
  Objects = g_Scene->getObjectList();
  
  Objects->beginIteration();
  while (( Obj = Objects->getNext() ) != NULL )
  {
    if (!Obj->isFlagged(OBJECTFLAG_SELECTED))
      Obj->setFlag(OBJECTFLAG_VISIBLE);
  }
  Objects->endIteration();
  
  ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
  
  return 1;
}

int KControlShowAll() {
  MBaseObjectTreePtr Objects;
  MBaseObjectPtr Obj;
  
  Objects = g_Scene->getObjectList();
  
  Objects->beginIteration();
  while (( Obj = Objects->getNext() ) != NULL ) {
    Obj->setFlag(OBJECTFLAG_VISIBLE);
  }
  Objects->endIteration();
  
  ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
  
  return 1;
}


int createViewWindow(MBaseViewWndPtr view, const char *className, const char *viewName, bool eraseBackground = false) {
  view->CreateEx(NULL, 
                 AfxRegisterWndClass(CS_OWNDC | CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS, 
                                     0, eraseBackground ? GetSysColorBrush(COLOR_3DFACE) : 0), 
                 viewName, 
                 WS_OVERLAPPEDWINDOW, 
                 CRect(10,10,500,500), 
                 g_MainDlg, 
                 0);

  view->ViewCreate();
  if (viewName != NULL) {
    view->SetViewName(viewName);
  }
  g_ViewList.AddView(view);
  view->ShowWindow(SW_SHOW);
  
  return 1;
}

int KWindowSceneOutline() {
  return createViewWindow(new CSceneViewWnd, "SceneView", "Scene Outline");
}

int KWindowUVEdit() {
  return createViewWindow(new CUVEditViewWnd, "UVEditView", "UV Edit");
}

int KWindowSegmentEdit() {
  return createViewWindow(new CSegmentViewWnd, "SegmentView", "Segment Editor");
}

int KWindowGraphView() {
  return createViewWindow(new CGraphViewWnd, "GraphView", "Graph View");
}

int KWindowParameterView() {
  return createViewWindow(new CParameterViewWnd, "ParameterView", "Parameter View");
}

int KWindowImageViewer() {
  return createViewWindow(new ImageViewerView, "ImageViewerView", "Image Viewer");
}

int KWindowRenderView() {
  // we can only change to a render view if there isn't one already visible
  MBaseViewWndPtr view = g_ViewList.FindViewOfType("RenderView");

  if (view == NULL) {
    return createViewWindow(new RenderView, "RenderView", "Render View");
  }

  return 0;
}

int KEditPurgeUndoLists() {

  Aztec::getSystemManager()->getUndoManager()->clearUndoInfo();
  return 1;
}

int KFileImportMaterial()
{  
  CFileDialog       Dlg(TRUE, "", NULL, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT |OFN_ALLOWMULTISELECT , "");
  MStr              Filter, Title;
  int               Res;
  MMaterialTranslatorPtr Trans;
  
  Filter = g_SysMan->createMaterialTranslatorFilterString();
  Filter.Replace('|', '\x0');
  Title = "Import";
  
  Dlg.m_ofn.lpstrTitle = (LPCTSTR)Title;
  Dlg.m_ofn.lpstrFilter = (LPCTSTR)Filter;
  
  if (Dlg.DoModal() == IDCANCEL)
    return 0;
  
  g_SysMan->getTranslatorFromIndex(Dlg.m_ofn.nFilterIndex, Trans);
  
  {
    POSITION    Pos;
    
    Pos = Dlg.GetStartPosition();
    
    while (Pos)
    {
      CString  Str;
      Str = Dlg.GetNextPathName(Pos);
      
      // If trans was NULL, then we check each translator against each file to see if it can be used
      if (Trans == NULL)
      {
        MMaterialTranslatorPtr MaterialTrans;
        
        MaterialTrans = g_SysMan->getPluginManager()->getMaterialTranslatorThatImports((LPCTSTR)Str);
        
        // If MaterialTrans is NULL, then no importers are available for that file
        if (MaterialTrans == NULL)
        {
          g_SysMan->logOutput("No suitable Translator could be found for '%s'.", (LPCTSTR)Str);
          continue;
        }
        Res = MaterialTrans->importFile((LPCTSTR)Str, g_Scene);
      }
      else
        Res = Trans->importFile((LPCTSTR)Str, g_Scene);
      
      if (!Res)
        g_SysMan->logOutput("Translator Could not import file '%s'.", (LPCTSTR)Str);
      else
        g_SysMan->logOutput("Translator imported '%s' successfully.", (LPCTSTR)Str);
    }
  }
  
  ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
  ::SendMessage(g_MainDlg->m_hWnd, MM_UPDATECHANNELBAR, 0, 0);
  
  return Res;
}

int KFileExportMaterial()
{
  CFileDialog          Dlg(FALSE, "", NULL, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, "");
  MStr                 Filter;
  int                  Res;
  MMaterialTranslatorPtr Trans;
  
  Filter = g_SysMan->createMaterialTranslatorFilterString();
  Filter.Replace('|', '\x0');
  Dlg.m_ofn.lpstrFilter = (LPCTSTR)Filter;
  Dlg.m_ofn.nFilterIndex = 2;
  
  
  if (Dlg.DoModal() == IDCANCEL)
    return 0;
  
  g_SysMan->getTranslatorFromIndex(Dlg.m_ofn.nFilterIndex, Trans);
  
  if (Trans != NULL) {
    Res = Trans->exportFile((LPCTSTR)Dlg.GetPathName(), g_Scene);
    if (!Res) {
      g_SysMan->logOutput("Translator '%s' Could not export file '%s'", (LPCTSTR)Trans->getClassName(), (LPCTSTR)Dlg.GetPathName());
    }
  } else {
    g_SysMan->logOutput("Could not find appropriate Translator for file '%s'", (LPCTSTR)Dlg.GetPathName());
    Res = 0;
  }
  
  return Res;
}

