//
// ColorWheel.cpp : implementation file
//

#include <AztecMainPCH.h>
#include "resource.h"
#include "ImageViewer.h"

#include "DlgGlobs.h"
#include "MdlMsgs.h"

#include <MSystemManager.h>

#include <math.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


const double pi = 3.141592654;

const float SCROLL_BAR_RANGE = 10000.0;


/////////////////////////////////////////////////////////////////////////////
// ImageViewer

ImageViewer::ImageViewer() 
{
}

ImageViewer::~ImageViewer()
{
}

BOOL ImageViewer::Create(const CRect &rect, CWnd *parent, bool visible) {
  DWORD style = WS_CHILD | WS_BORDER | WS_HSCROLL | WS_VSCROLL | WS_CLIPSIBLINGS | WS_CLIPCHILDREN;

  if (visible) {
    style |= WS_VISIBLE;
  }

  return CWnd::Create(NULL, 
                      "imageViewer", 
                      style,
                      rect, 
                      parent,
                      -1);
}


void ImageViewer::setImage(const MImagePtr newImage) {
  CClientDC   dc(this);
  image = newImage;
  imageToPaint.setFromImage(newImage, dc.m_hDC);

  imageRect.left = 0;
  imageRect.top = 0;
  imageRect.right = imageToPaint.m_Width;
  imageRect.bottom = imageToPaint.m_Height;
}

MImagePtr ImageViewer::getImage() {
  return image;
}

BEGIN_MESSAGE_MAP(ImageViewer, CWnd)
//{{AFX_MSG_MAP(ImageViewer)
ON_WM_PAINT()
ON_WM_NCHITTEST()
ON_WM_LBUTTONDOWN()
ON_WM_MOUSEMOVE()
ON_WM_ERASEBKGND()
ON_WM_LBUTTONUP()
ON_WM_CREATE()
ON_WM_HSCROLL()
ON_WM_VSCROLL()
//}}AFX_MSG_MAP
END_MESSAGE_MAP()



/////////////////////////////////////////////////////////////////////////////
// ImageViewer message handlers

void ImageViewer::OnPaint() 
{
    // Do some initialization
  if (imageToPaint.m_Width == 0) {
    setImage(MSystemManager::getInstance()->loadImage("d:/temp/test44.jpg"));
  }

  CPaintDC dc(this);
  
  int imageWidth = imageRect.Width();
  int imageHeight = imageRect.Height();
  RECT rect;
  GetClientRect(&rect);

  int clientWidth = rect.right - rect.left;
  int clientHeight = rect.bottom - rect.top;

  float imageToViewX = (float)imageWidth / (float)clientWidth;
  float imageToViewY = (float)imageHeight / (float)clientHeight;

  float factorX = imageWidth;
  float factorY = imageHeight;

  if (imageWidth > clientWidth) {
    factorX -= (float)clientWidth / 1.2;
  }
  if (imageHeight > clientHeight) {
    factorY -= (float)clientHeight / 1.2;
  }

  int imageCentreX = clientWidth / 2 - factorX * ((float)GetScrollPos(SB_HORZ) / SCROLL_BAR_RANGE);
  int imageCentreY = clientHeight / 2 - factorY * ((float)GetScrollPos(SB_VERT) / SCROLL_BAR_RANGE);


  // get the client size, and cente our image.
  imageRect.left = imageCentreX - imageWidth / 2;
  imageRect.top = imageCentreY - imageHeight / 2;
  imageRect.right = imageRect.left + imageWidth;
  imageRect.bottom = imageRect.top + imageHeight;

  imageToPaint.Draw(dc.m_hDC, imageRect.left,imageRect.top);
  // Copy backbuffer to the front
//  dc.BitBlt(0,0,imageRect.Width(),imageRect.Height(),m_Buffer,0,0,SRCCOPY);

  // blank out any extra space there might be.
  int borderWidth = 2;

  // if we have some spare space on the left, paint it in.
  if (imageRect.left - borderWidth > rect.left) {
    RECT paintRect = {0, 0, imageRect.left - borderWidth, rect.bottom};
    ::FillRect(dc.m_hDC, &paintRect, (HBRUSH)::GetStockObject(BLACK_BRUSH));
  }
  // if we have some spare space on the right, paint it in.
  if (imageRect.right + borderWidth < rect.right) {
    RECT paintRect = {imageRect.right + borderWidth, 0, rect.right, rect.bottom};
    ::FillRect(dc.m_hDC, &paintRect, (HBRUSH)::GetStockObject(BLACK_BRUSH));
  }


  // if we have some spare space on the bottom, paint it in.
  if (imageRect.bottom + borderWidth < rect.bottom) {
    RECT paintRect = { imageRect.left - borderWidth, imageRect.bottom + borderWidth, imageRect.right + borderWidth, rect.bottom };
    ::FillRect(dc.m_hDC, &paintRect, (HBRUSH)::GetStockObject(BLACK_BRUSH));
  }

  // if we have some spare space on the top, paint it in.
  if (imageRect.top - borderWidth > rect.top) {
    RECT paintRect = { imageRect.left - borderWidth, rect.top, imageRect.right + borderWidth, imageRect.top - borderWidth };
    ::FillRect(dc.m_hDC, &paintRect, (HBRUSH)::GetStockObject(BLACK_BRUSH));
  }


  // draw a border around the image so we can see the extents of it
  RECT paintRect = {imageRect.left, imageRect.top, imageRect.right, imageRect.bottom };

  while (borderWidth > 0) {
    paintRect.left--;
    paintRect.top--;
    paintRect.right++;
    paintRect.bottom++;

    ::SelectObject(dc.m_hDC, ::GetStockObject(HOLLOW_BRUSH));
    ::SelectObject(dc.m_hDC, ::GetStockObject(WHITE_PEN));
    ::Rectangle(dc.m_hDC, paintRect.left, paintRect.top, paintRect.right, paintRect.bottom);

    --borderWidth;
  }

}

UINT ImageViewer::OnNcHitTest(CPoint point) 
{
  return CWnd::OnNcHitTest(point);
    // Return HTCLIENT so that we can get mouse messages from this control
    return HTCLIENT;
}

void ImageViewer::PreSubclassWindow() 
{
  // TODO: Add your specialized code here and/or call the base class
  CWnd::PreSubclassWindow();
    
}

void ImageViewer::OnMouseMove(UINT nFlags, CPoint point) 
{
    CWnd::OnMouseMove(nFlags, point);
}

void ImageViewer::OnLButtonDown(UINT nFlags, CPoint point) 
{
  CWnd::OnLButtonDown(nFlags, point);
}

void ImageViewer::OnLButtonUp(UINT nFlags, CPoint point) 
{
  CWnd::OnLButtonUp(nFlags, point);
}

int ImageViewer::OnCreate(LPCREATESTRUCT lpCreateStruct) {
  // set up the scroll bars.
  SetScrollRange(SB_VERT, -SCROLL_BAR_RANGE / 2, SCROLL_BAR_RANGE / 2);
  SetScrollRange(SB_HORZ, -SCROLL_BAR_RANGE / 2, SCROLL_BAR_RANGE / 2);

  return 0;
}

void ImageViewer::OnHScroll( UINT nSBCode, UINT nPos, CScrollBar* pScrollBar ) {
  doScroll(SB_HORZ, nSBCode, nPos);
}

void ImageViewer::OnVScroll( UINT nSBCode, UINT nPos, CScrollBar* pScrollBar ) {
  doScroll(SB_VERT, nSBCode, nPos);
}


BOOL ImageViewer::OnEraseBkgnd(CDC* pDC) 
{
    // Don't.. just don't do it
    return true;
}


void ImageViewer::SendMessageToParent(int Message)
{
    CWnd* pWnd = GetParent();

    if (pWnd)
    {
        pWnd->PostMessage(WM_COMMAND, (WPARAM)(WM_USER+1));
    }
}

void ImageViewer::doScroll(UINT scrollBar, UINT nSBCode, UINT nPos) {
  int pos;
  int imageWidth = imageRect.Width();
  int imageHeight = imageRect.Height();
  
  if (imageWidth == 0 || imageHeight == 0) {
    return;
  }

  pos = GetScrollPos(scrollBar);
  
  if (nSBCode == SB_THUMBTRACK) {
    pos = nPos;
  }
  if (nSBCode == SB_LINEUP) {
    pos -= SCROLL_BAR_RANGE / (scrollBar == SB_HORZ ? imageWidth : imageHeight);
  }
  if (nSBCode == SB_LINEDOWN) {
    pos += SCROLL_BAR_RANGE / (scrollBar == SB_HORZ ? imageWidth : imageHeight);
  }
  if (nSBCode == SB_PAGEUP) {
    pos -= 20 * SCROLL_BAR_RANGE / (scrollBar == SB_HORZ ? imageWidth : imageHeight);
  }
  if (nSBCode == SB_PAGEDOWN) {
    pos += 20 * SCROLL_BAR_RANGE / (scrollBar == SB_HORZ ? imageWidth : imageHeight);
  }
  
  SetScrollPos(scrollBar, pos);
  InvalidateRect(NULL);
}



