#include <AztecMainPCH.h>


#include <controls/GLCanvas.h>
#include <MSystemManager.h>


GLCanvas::GLCanvas() {
  needToCreateFonts = true;
}

BOOL GLCanvas::Create(DWORD style, const RECT &rect, CWnd *parent, UINT id) {
  BOOL result = CWnd::Create(NULL, "glCanvas", WS_CHILD | style, rect, parent, id);

  if (result == FALSE) {
    return result;
  }

  initOpenGL();

  return TRUE;
}

HGLRC GLCanvas::getGLContext() {
  return glContext;
}

GLCanvas::GLErrorEnum GLCanvas::makeCurrent(HDC dc) {
  if (needToCreateFonts) {
    createFonts(GLVIEW_FONTSTART, dc);
  }

  HGLRC	CurrentContext;
  int result = 0;
  bool needToRelease = false;

  CurrentContext = wglGetCurrentContext();

  if (dc == NULL) {
    dc = ::GetDC(m_hWnd);
    needToRelease = true;
  }
  
  if (CurrentContext != glContext) {
    if (wglMakeCurrent(dc, glContext) == FALSE) {
      result = GL_MAKECURRENT_FAILED;
    }
  }
  
  if (needToRelease) {
    ::ReleaseDC(m_hWnd, dc);
  }
  
  return GL_OK;
}

int GLCanvas::swapBuffers(HDC dc) {
  bool needToRelease = false;
  int result;
  
  if (dc == NULL) {
    dc = ::GetDC(m_hWnd);
    needToRelease = true;
  }
  
  result = SwapBuffers(dc);

  if (needToRelease) {
    ::ReleaseDC(m_hWnd, dc);
  }
  
  return result;
}

void GLCanvas::createFonts(DWORD glListIndex, HDC dc) {
  if (::IsWindowVisible(m_hWnd) == TRUE) {
    bool needToRelease = false;
    if (dc == NULL) {
      dc = ::GetDC(m_hWnd);
      needToRelease = true;
    }

    BOOL result;
    HGDIOBJ oldFont = ::SelectObject(dc, ::GetStockObject(DEFAULT_GUI_FONT));
   
    // don't create the fonts if the it has already been made.
    if (!glIsList(glListIndex)) {

      result = ::wglUseFontBitmaps(dc, 0, 255, glListIndex);

      if (result == FALSE) {
        DWORD err;
    
        err = ::GetLastError();
        MSystemManager::getInstance()->logOutput("MBaseOpenGLWnd::createFonts() - Error creating Fonts (%i)", err);
      } else {
        needToCreateFonts = false;
      }

    } else {
      needToCreateFonts = false;
    }
  
    ::SelectObject(dc, oldFont);

    if (needToRelease) {
      ::ReleaseDC(m_hWnd, dc);
    }
  }
}

void GLCanvas::onMouseUp(int x, int y, MShiftState Shift) {
}

void GLCanvas::onMouseDown(int x, int y, MShiftState Shift) {
}

void GLCanvas::onMouseMove(int x, int y, MShiftState Shift) {
}

LRESULT GLCanvas::DefWindowProc(UINT message, WPARAM wParam, LPARAM lParam) {
  if (message == WM_LBUTTONDOWN ||
      message == WM_MBUTTONDOWN ||
      message == WM_RBUTTONDOWN) {
    MShiftState newState;
    newState.SetFromKeyState();
    newState.SetFromFlags(wParam);
    int x = (short int)LOWORD(lParam);
    int y = (short int)HIWORD(lParam);

    onMouseDown(x,y,newState);
  } else if (message == WM_LBUTTONUP ||
            message == WM_MBUTTONUP ||
            message == WM_RBUTTONUP) {
    MShiftState newState;
    newState.SetFromKeyState();
    newState.SetFromFlags(wParam);
    int x = (short int)LOWORD(lParam);
    int y = (short int)HIWORD(lParam);

    onMouseUp(x,y,newState);
  } else if (message == WM_MOUSEMOVE) {
    MShiftState newState;

    newState.SetFromKeyState();
    newState.SetFromFlags(wParam);
    int x = (short int)LOWORD(lParam);
    int y = (short int)HIWORD(lParam);

    onMouseMove(x,y,newState);
  }
  return CWnd::DefWindowProc(message, wParam, lParam);
}



GLCanvas::GLErrorEnum GLCanvas::initOpenGL() {
  PIXELFORMATDESCRIPTOR pfd = {
    sizeof(PIXELFORMATDESCRIPTOR),// size of this pfd
      1,                     // version number 
      PFD_DRAW_TO_WINDOW |   // support window 
      PFD_SUPPORT_OPENGL |   // support OpenGL 
      PFD_DOUBLEBUFFER,      // double buffered 
      PFD_TYPE_RGBA,         // RGBA type 
      16,                    // bit color depth 
      0, 0, 0, 0, 0, 0,      // color bits ignored 
      0,                     // no alpha buffer 
      0,                     // shift bit ignored 
      0,                     // no accumulation buffer 
      0, 0, 0, 0,            // accum bits ignored 
      16,                    // z-buffer 
      0,                     // no stencil buffer 
      0,                     // no auxiliary buffer 
      PFD_MAIN_PLANE,        // main layer 
      0,                     // reserved 
      0, 0, 0                // layer masks ignored 
  }; 
  int  iPixelFormat;
  
  HDC hDC = ::GetDC(m_hWnd);
  
  // get the best available match of pixel format for the device context  
  iPixelFormat = ChoosePixelFormat(hDC, &pfd); 
  
  // make that the pixel format of the device context 
  MSystemManager::getInstance()->logOutput("OpenGLWnd::InitOpenGL() - Pixel Format %ibpp, %iAlpha bits, %iZBuf", pfd.cColorBits, pfd.cAlphaBits, pfd.cDepthBits);
  SetPixelFormat(hDC, iPixelFormat, &pfd); 	
  

  // since the pixel format has been set, we can create the opengl rendering context
  // and set it as active.
  
  glContext = wglCreateContext(hDC);

  ::ReleaseDC(m_hWnd, hDC);

  if (glContext == NULL) {
    MSystemManager::getInstance()->logOutput("OpenGLWnd::InitOpenGL() - context Creation failed!");
    return GL_CREATECONTEXT_FAILED;
  }
  
  if (makeCurrent() == GL_MAKECURRENT_FAILED) {
    MSystemManager::getInstance()->logOutput("OpenGLWnd::InitOpenGL() - Make current failed!");
    return GL_MAKECURRENT_FAILED;
  }
  
  // put in some dummy values
  glViewport(0,0,900,900);
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  float m_Aspect = 1;
  glMatrixMode(GL_MODELVIEW);
  
  glShadeModel(GL_SMOOTH);
  
  glEnable(GL_DEPTH_TEST);
  glEnable(GL_CULL_FACE);
  glEnable(GL_NORMALIZE);
  glCullFace(GL_BACK);
  
  glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);
  
  glShadeModel(GL_SMOOTH);
  glEnable(GL_LIGHT0);


  return GL_OK;
}

GLCanvas::GLErrorEnum GLCanvas::killOpenGL() {
  // Make the current context not null.
  wglMakeCurrent(NULL, NULL);
  wglDeleteContext(glContext);
  glContext = NULL;

  return GL_OK;
}

void GLCanvas::GLDrawText(float x, float y, const MStr &str) {
  glRasterPos2d(x,y);
  glListBase(GLVIEW_FONTSTART);
  glCallLists(str.GetLength(), GL_UNSIGNED_BYTE, (LPCTSTR)str);
}
