// DragScrollDlg.cpp : implementation file
//

#include <AztecMainPCH.h>
#include "DragScrollDlg.h"

#include "HelperFuncs.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDragScrollDlg dialog


CDragScrollDlg::CDragScrollDlg(UINT nIDTemplate, CWnd* pParent /*=NULL*/)
	: CDialog(nIDTemplate, pParent)
{
	//{{AFX_DATA_INIT(CShelfDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
   m_ScrollX = 0;
   m_ScrollY = 0;
   m_Dragging = 0;
   m_VerticalScroll = true;
   m_HorizontalScroll = true;
}

CDragScrollDlg::CDragScrollDlg()
{
   m_ScrollX = 0;
   m_ScrollY = 0;
   m_Dragging = 0;
   m_VerticalScroll = true;
   m_HorizontalScroll = true;
}

/*
CDragScrollDlg::CDragScrollDlg(CWnd* pParent )
	: CDialog(CDragScrollDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDragScrollDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT

   m_ScrollX = 0;
   m_ScrollY = 0;
   m_Dragging = false;
}
*/

void CDragScrollDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDragScrollDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDragScrollDlg, CDialog)
	//{{AFX_MSG_MAP(CDragScrollDlg)
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_MOUSEMOVE()
	ON_WM_SIZE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDragScrollDlg message handlers

void CDragScrollDlg::GetChildExtents(RECT *lpRect)
{
   lpRect->left = 0;
   lpRect->right = 0;
   lpRect->bottom = 0;
   lpRect->top = 0;

   GetChildExtents(m_hWnd, lpRect);
   lpRect->right += 10;
   lpRect->bottom += 10;
}

void CDragScrollDlg::GetChildExtents(HWND hParent, RECT *lpRect)
{
   RECT  Rect;
   HWND  LasthWnd;

   Rect.bottom = 0;
   Rect.left = 0;
   Rect.top = 0;
   Rect.right = 0;

   LasthWnd = NULL;

   while (LasthWnd = ::FindWindowEx(hParent, LasthWnd, NULL,NULL))
   {
      // we now have a window handle, get the window position
      POINT       P;

      ::GetWindowRect(LasthWnd, &Rect);
      P.x = Rect.left;
      P.y = Rect.top;
      ::ScreenToClient(hParent, &P);
      Rect.left = P.x;
      Rect.top = P.y;
      P.x = Rect.right;
      P.y = Rect.bottom;
      ::ScreenToClient(hParent, &P);
      Rect.right = P.x;
      Rect.bottom = P.y;

      if (Rect.left < lpRect->left)
         lpRect->left = Rect.left;
      if (Rect.top < lpRect->top)
         lpRect->top = Rect.top;

      if (Rect.right > lpRect->right)
         lpRect->right = Rect.right;
      if (Rect.bottom > lpRect->bottom)
         lpRect->bottom = Rect.bottom;

   }

   lpRect->right -= lpRect->left;
   lpRect->bottom -= lpRect->top;
   lpRect->left = 0;
   lpRect->top = 0;
}

BOOL CDragScrollDlg::PreTranslateMessage(MSG* pMsg) 
{
   bool     ProcessScroll;

   ProcessScroll = false;

   if (pMsg->hwnd == m_hWnd)
      ProcessScroll = true;

   if (::IsChild(m_hWnd, pMsg->hwnd))
      ProcessScroll = true;

   if (ProcessScroll && pMsg->message == WM_MBUTTONDOWN)
   {
      SetCapture();
      POINT    P;
      XYFromDWORD(pMsg->lParam, &P);
      ::ClientToScreen(pMsg->hwnd, &P);
      ::ScreenToClient(m_hWnd, &P);
      m_OldX = P.x;
      m_OldY = P.y;
      m_Dragging = true;
      return 1;      
   }
   if (ProcessScroll && pMsg->message == WM_MBUTTONUP)
   {
      m_Dragging = false;
      ReleaseCapture();
      return 1;      
   }

   if (pMsg->hwnd == m_hWnd)
   {
      if (pMsg->message == WM_LBUTTONDOWN)
      {
         ::SetCapture(pMsg->hwnd);
         POINT    P;
         
         XYFromDWORD(pMsg->lParam, &P);
         ::ClientToScreen(pMsg->hwnd, &P);
         ::ScreenToClient(m_hWnd, &P);
         m_OldX = P.x;
         m_OldY = P.y;
         m_Dragging = true;
         return 1;
      }
      if (pMsg->message == WM_LBUTTONUP)
      {
         ReleaseCapture();
         m_Dragging = false;
         return 1;
      }
      if (pMsg->message == WM_MOUSEMOVE)
      {
         ::SetCursor(::LoadCursor(NULL, IDC_SIZEALL));
         if (m_Dragging)
         {
            int   DiffX, DiffY;
            RECT  Rect, ClientRect;
            int   X, Y;

            XYFromDWORD(pMsg->lParam, X,Y);
            DiffX = X - m_OldX;
            DiffY = Y - m_OldY;
            
            GetChildExtents(&Rect);
            GetClientRect(&ClientRect);
            
            if (ClientRect.right >= Rect.right)
            {
               DiffX = -m_ScrollX;
            }
            if (ClientRect.bottom >= Rect.bottom)
            {
               DiffY = -m_ScrollY;
            }
            
            
            
            if (m_ScrollX + DiffX > 0)
               DiffX = -m_ScrollX;
            if (m_ScrollY + DiffY > 0)
               DiffY = -m_ScrollY;
            
            if (ClientRect.right < Rect.right)
            {
               if (m_ScrollX + DiffX < -Rect.right + ClientRect.right)
                  DiffX = -Rect.right + ClientRect.right - m_ScrollX;
            }
            if (ClientRect.bottom < Rect.bottom)
            {
               if (m_ScrollY + DiffY < -Rect.bottom + ClientRect.bottom)
                  DiffY = -Rect.bottom + ClientRect.bottom - m_ScrollY;
            }
            
            if (DiffX != 0 || DiffY != 0)
            {
               if (!m_VerticalScroll)
                  DiffY = 0;
               if (!m_HorizontalScroll)
                  DiffX = 0;
               ScrollWindow(DiffX, DiffY);
               m_ScrollX += DiffX;
               m_ScrollY += DiffY;
            }

            m_OldX = X;
            m_OldY = Y;
                  
            return 1;
         }
      }
      if (pMsg->message == WM_SIZE || pMsg->message == WM_WINDOWPOSCHANGED || pMsg->message == WM_WINDOWPOSCHANGING)
      {
         CDialog::PreTranslateMessage(pMsg);

         int   DiffX, DiffY;
         RECT  Rect, ClientRect;

         DiffX = 0;
         DiffY = 0;

         GetChildExtents(&Rect);
         GetClientRect(&ClientRect);

         if (ClientRect.right + m_ScrollX >= Rect.right)
         {
            DiffX = -m_ScrollX;
         }
         if (ClientRect.bottom + m_ScrollY >= Rect.bottom)
         {
            DiffY = -m_ScrollY;
         }

         if (m_ScrollX + DiffX > 0)
            DiffX = -m_ScrollX;
         if (m_ScrollY + DiffY > 0)
            DiffY = -m_ScrollY;

         if (ClientRect.right < Rect.right)
         {
            if (m_ScrollX + DiffX < -Rect.right + ClientRect.right)
               DiffX = -Rect.right + ClientRect.right - m_ScrollX;
         }
         if (ClientRect.bottom < Rect.bottom)
         {
            if (m_ScrollY + DiffY < -Rect.bottom + ClientRect.bottom)
               DiffY = -Rect.bottom + ClientRect.bottom - m_ScrollY;
         }

         if (DiffX != 0 || DiffY != 0)
         {
            if (!m_VerticalScroll)
               DiffY = 0;
            if (!m_HorizontalScroll)
               DiffX = 0;
            ScrollWindow(DiffX, DiffY);
            m_ScrollX += DiffX;
            m_ScrollY += DiffY;
         }

         return 1;      
      }
   }
   
   return CDialog::PreTranslateMessage(pMsg);
}
