#if !defined(AFX_UVEDITVIEWWND_H__8E4C0543_2A37_11D3_847D_0040332C7B2F__INCLUDED_)
#define AFX_UVEDITVIEWWND_H__8E4C0543_2A37_11D3_847D_0040332C7B2F__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "BaseOpenGLWnd.h"
#include <views/MZoomableWindow.h>

class CUVEditViewWnd;
typedef MRefCountedPtr<CUVEditViewWnd> CUVEditViewWndPtr;

class CUVEditViewWnd : public MBaseOpenGLWnd, public MZoomableWindow {
  // Construction
public:
  CUVEditViewWnd();
  
  // Class related
  virtual MStr getClassName() {return MStr("CUVEditViewWnd");};
  virtual MStr getParentClassName() {return MStr("MBaseOpenGLWnd");};
  virtual MBaseObjectPtr createNew();
  
  // Draws the manipulators for the current tool in the corect plance. If Select == true, then 
  // The manipulatros are drawn using glRenderMode(GL_SELECT)
  int DrawManipulators(bool Select);
  
  MVector3       m_Pan;
  float          m_Zoom, m_ImageAspect;
  
  // BaseOpenGLWnd methods
  virtual void AdjustProjectionMatrix(MSelectMethod PickMode = smNone, 
                                      int left = -1, int top = -1,
                                      int right = -1, int bottom = -1);
  virtual void DoViewportTransform();
  // Draws anything in the view that goes on top of everything else, eg View Labels
  // or anything that is drawn in screen space
  virtual void DrawViewExtras();

  // BaseViewWnd methods
  virtual void ViewCreate();
  virtual void DrawView();
  virtual void onMouseUp(int X, int Y, MShiftState Shift);
  virtual void onMouseDown(int X, int Y, MShiftState Shift);
  virtual void onMouseMove(int x, int y, MShiftState Shift);
  virtual DWORD ViewPopupMenu(int x, int y);
  virtual int HandlePopupCommand(DWORD Cmd);
  
  // MZoomableWindow methods
  void zoomIn();
  void zoomOut();
  void zoomToFitAll();
  void zoomToFitSelected();

  // Feedback method
  void updateSelectionFeedback();
  
protected:
  MActionType    m_Action;
  
  void screenToUV(int x, int y, float &u, float &v);
  
  // Overrides
  // ClassWizard generated virtual function overrides
  //{{AFX_VIRTUAL(CUVEditViewWnd)
public:
  virtual BOOL PreTranslateMessage(MSG* pMsg);
protected:
  virtual LRESULT WindowProc(UINT message, WPARAM wParam, LPARAM lParam);
  //}}AFX_VIRTUAL
  
  // Implementation
public:
  virtual ~CUVEditViewWnd();
  
  // Generated message map functions
protected:
  //{{AFX_MSG(CUVEditViewWnd)
  afx_msg void OnPaint();
  afx_msg void OnSize(UINT nType, int cx, int cy);
  afx_msg void OnDestroy();
  afx_msg void OnClose();
  //}}AFX_MSG
  DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_UVEDITVIEWWND_H__8E4C0543_2A37_11D3_847D_0040332C7B2F__INCLUDED_)
