#ifndef MPolylineAddPointTool_Header
#define MPolylineAddPointTool_Header

#include <tools/MXYZToolType.h>

// AztecLib includes
#include <MLineShape.h>
#include <MLineMesh.h>

//---------------------
//  MPolylineAddPointTool
//---------------------
class MPolylineAddPointTool : public MXYZToolType {
public:
  MPolylineAddPointTool();
  virtual int DrawTool(bool Select, MShiftState ShiftState, MBaseViewWndPtr View);
  virtual int onMouseDown(int X, int Y, const MShiftState &Shift);
  virtual int onMouseMove(int X, int Y, const MShiftState &Shift);
  virtual int onMouseUp(int X, int Y, const MShiftState &Shift);

private:
  bool dragging;

  MSceneObjectPtr sceneObj;
  MLineShapePtr shapeObj;
  MLineMeshPtr meshObj;

  void getMeshObject();
  MVector3 getPositionFromMouse(int x, int y);
};

#endif