#ifndef MGLRotateTool_Header
#define MGLRotateTool_Header

#include <MXYZToolType.h>

//----------------------------------------------------------------------------------------
//  MGLRotateToolType
//----------------------------------------------------------------------------------------
class MGLRotateToolType : public MXYZToolType
{
protected:
   MVector3    m_Orig, m_VecA, m_VecB, m_VecC, m_VecD, m_PivotPoint, m_ViewNorm;
   float       m_RotAng;

public:
   MGLRotateToolType();
   virtual int DrawTool(bool Select, MShiftState ShiftState, MBaseViewWndPtr View);
   virtual int onMouseDown(int X, int Y, const MShiftState &Shift);
   virtual int onMouseUp(int X, int Y, const MShiftState &Shift);
   virtual int onMouseMove(int X, int Y, const MShiftState &Shift);
   virtual int GetDefaultManip() {return 4;};
};


//----------------------------------------------------------------------------------------
//  MRotateToolType
//----------------------------------------------------------------------------------------
class MRotateToolType : public MGLRotateToolType
{
public:
   MRotateToolType();
   virtual int DrawTool(bool Select, MShiftState ShiftState, MBaseViewWndPtr View);
   virtual int onMouseDown(int X, int Y, const MShiftState &Shift);
   virtual int onMouseUp(int X, int Y, const MShiftState &Shift);
   virtual int onMouseMove(int X, int Y, const MShiftState &Shift);
   virtual int GetDefaultManip() {return 4;};
};

#endif