#ifndef KeyboardH
#define KeyboardH

#include "MStr.h"
#include "MenuItem.h"


#include <map>
#include <vector>

class MAction;
class MActionListType;
class MKeystroke;
class MKeyActionMap;

typedef int ActionFunc(void);
typedef int CALLBACK EnumActionFunc(MAction *A, DWORD lParam);


//----------------------------------------------------------------------------------------
//  MAction
//----------------------------------------------------------------------------------------

class MAction {
public:
  MStr	         m_DisplayName, m_ActionName,  m_Cat;
  ActionFunc     *m_Exec;
  
  CMenuItem      m_Menu;
  
  MAction        *m_Next, *m_Prev;
  
  MAction();
  MAction(const MStr &ActionName, const MStr &DisplayName, ActionFunc *E, CMenuItem M);
  MAction(const MStr &ActionName, const MStr &DisplayName, const MStr &C, ActionFunc *E, CMenuItem M);
  void Set(const MStr &ActionName, const MStr &DisplayName, ActionFunc *E, CMenuItem M);
  void Set(const MStr &ActionName, const MStr &DisplayName, const MStr &C, ActionFunc *E, CMenuItem M);
};

//----------------------------------------------------------------------------------------
//  MActionListType
//----------------------------------------------------------------------------------------
class MActionListType {
public:
  MAction     *m_First;
  MStr        m_Name;
  
  MActionListType();
  ~MActionListType();
  
  int Add(const MStr &ActionName, const MStr &DisplayName, ActionFunc *E, CMenuItem M);
  int Add(const MStr &ActionName, const MStr &DisplayName, const MStr &Cat, ActionFunc *E, CMenuItem M = CMenuItem());
  int Add(const MStr &ActionName, const MStr &DisplayName, const MStr &Cat, ActionFunc *E, CWnd *Wnd, UINT IDItem);
  int Sort();
  
  int EnumList(EnumActionFunc *Func, int lParam);
  
  MAction* GetAction(int i);
  MAction* operator[](int i);
};

//----------------------------------------------------------------------------------------
//  MKeystroke
//----------------------------------------------------------------------------------------
class MKeystroke {
public:
  WORD        m_Key;
  bool        m_Ctrl, m_Alt, m_Shift;
  CMenuItem   m_Erase;
  MStr        m_Category;
  
  MKeystroke();
  MKeystroke(const MKeystroke &src);
  MKeystroke( MAction *Ac, WORD K, bool C, bool A, bool S);
  MKeystroke( const MStr &category, WORD K, bool C, bool A, bool S);
  ~MKeystroke();
  
  int ChangeMenuSC();
  MStr GetKeystrokeString();

  MAction* getAction();
  void setAction(MAction *act);

  /**
   * comparison operator for use with STL containers
   */
  bool operator<(const MKeystroke &rhs);
  /**
   * equality operator for common use
   */
  bool operator==(const MKeystroke &rhs);

protected:
  MAction     *m_Act;
};

MStr VKeyToString(WORD Ch, WORD Old=0);

//----------------------------------------------------------------------------------------
//  MKeyActionMap
//----------------------------------------------------------------------------------------
class MKeyActionMap {
public:
  std::vector<MKeystroke>  m_Keys;
  MActionListType     *m_Actions;
  
  MKeyActionMap();
  ~MKeyActionMap();
  
  int Add(const MStr &ActionName, const MStr &Cat, WORD K, bool C, bool A, bool S);
  int Remove();
  int Remove(int index);
  int Remove(const MKeystroke &key);
  void RemoveAll();
  int Set(int n, const MStr &ActionName, const MStr &Cat, WORD K, bool C, bool A, bool S);
  int Change(int n, const MStr &ActionName, const MStr &Cat, WORD K, bool C, bool A, bool S);
  void UpdateAllMenus();
  
  int SortAlpha();
  
  // Finds the given keystroke
  MKeystroke* FindKey(WORD K, const MStr &Cat, bool C, bool A, bool S);
  // Finds the Key associated with the given Action and Category
  MKeystroke* FindKey(const MStr &ActionName, const MStr &Cat);
  
  // Executes the given keystroke if it is in the list
  int ExecuteKey(WORD K, bool C, bool A, bool S, const MStr &Cat);
  // Executes the key associated with the given menu
  int ExecuteAction(HMENU hMenu, DWORD nID, const MStr &Cat);
  // Executes the action of the given name.
  int ExecuteAction(const MStr &ActionName);
  
  // Finds the Action given the actionName and Category
  MAction* FindAction(const MStr &ActionName, const MStr &Cat);
  // Finds an action by number
  MAction* FindAction(int n);
  // Finds the given keystroke from the Menu handle and ID
  MAction* FindAction(HMENU hMenu, DWORD nID, const MStr &Cat);
  
  int numMappings();
  
  int SaveToFile(MStr FileName);
  int OutputPlainText(MStr Filename);
  int LoadFromFile(MStr FileName);
  
  MKeystroke* operator[](int n);
  MKeyActionMap& operator=(MKeyActionMap &RHS);
  
};



#endif
