#ifndef MTOOLTIPWND_H
#define MTOOLTIPWND_H

#include "MBaseObject.h"
#include "MStr.h"

class MToolTipWnd : public MBaseObject
{
public:
   MToolTipWnd();
   virtual ~MToolTipWnd();

   int CreateToolTip(HWND ParentWnd, int X, int Y, int ShowTime, int Timeout, const MStr &Message);
   void DestroyToolTip();
   HWND GetParentWnd() {return m_hParentWnd;};
   void SetMouseOverWnd(HWND MouseOverWnd);
   HWND GetMouseOverWnd();

protected:
   int         m_TimeOut, m_TimerID, m_ShowTime;
   HWND        m_hWnd, m_hParentWnd, m_hMouseOverWnd;
   DWORD       m_ThreadID;
   HANDLE      m_hThread;
   MStr        m_Text;

   int CreateToolWnd(int X, int Y);
   int DestroyToolWnd();


};


extern MToolTipWnd       g_ToolTipWnd;


#endif