#if !defined(AFX_IMAGEBUTTON_H__65ED1E04_41BD_11D3_9A60_0040332C7B2F__INCLUDED_)
#define AFX_IMAGEBUTTON_H__65ED1E04_41BD_11D3_9A60_0040332C7B2F__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000


#include "MStr.h"
#include "MToolManager.h"


//----------------------------------------------------------------------------------------
//  MDIBImage
//----------------------------------------------------------------------------------------
// this class provides a simple ecapsulation of Device independant bitmaps, 
// and a simple mechanism for loading them from .bmp files. This is intended
// primarily for button drawing and similar tasks
class MDIBImage
{
public:
   BITMAPINFOHEADER     m_BitmapInfoHeader;
   BYTE                 *m_CompleteHeader;   // A complete header, consiting of both palette and header
   RGBQUAD              *m_Palette;          // Palette of image, if requred.
   BYTE                 *m_Pixels;           // Actual Pixel data
   HBITMAP              m_hBitmap;           // Handle to the bitmap

   int                  m_Width, m_Height, m_Depth;

   MDIBImage();
   virtual ~MDIBImage();

   int CreateEmptyBitmap(HDC hDC, int Width, int Height, int Depth, RGBQUAD *SrcPalette = NULL);
   int SetFromBitmap(const MDIBImage &Bmp, HDC hDC = NULL);
   void DeleteBitmap();
   void setFromImage(const MImagePtr &newImage, HDC hDC);

   int Draw(HDC hDC, int x, int y, int w=-1, int h=-1);
   int Draw(HDC hDC, int destx, int desty, int srcx, int srcy, int w, int h);

   int LoadFromBMP(const char *Filename, HDC hDC = NULL);
};


//----------------------------------------------------------------------------------------
//  CImageButton
//----------------------------------------------------------------------------------------
class CImageButton : public CButton
{
protected:
   MDIBImage      m_Image;

   /**
    * This is the name of the function that should be called when this button
    * is clicked.
    */
   MStr m_ActionName;

   /**
    * The filename of the image to draw on this button.
    */
   MStr m_ImageFilename;

   /**
    * The function group that this button belongs to. This is so the tool manager
    * can look at buttons and match up current tools and a group to a button.
    */
   MStr m_ToolGroup;

   UINT m_TimerID, m_FirstTimer, m_Timed;
   bool m_Executing, m_ToolTipTimed;
   int m_TipX, m_TipY;
   MToolChangeListenerPtr listener;
   bool m_Checked;
   bool m_Repeatable;
public:
	CImageButton(const MStr &actionName = "", const MStr &toolGroup = "");
   
   int SetFrom(const CImageButton &But, bool ResizeCtrl = true);
   int SetImage(const char *Filename, bool ResizeCtrl = true);
   int SetImage(const MStr &Filename, bool ResizeCtrl = true);
   void SetActionName(const MStr &ActionName);
   const MStr& GetActionName() {return m_ActionName;};
   const MStr& GetImageFilename() {return m_ImageFilename;};

   MStr getToolGroup() {
     return m_ToolGroup;
   }

   void setChecked(bool checked);
   bool isChecked();

   void setPosition(int left, int top);
   void setLeft(int left);
   void setTop(int top);
   void setSize(int width, int height);
   int getWidth();
   int getHeight();
   int getLeft();
   int getTop();
   void getPosition(RECT *rect);

   void setRepeatable(bool repeatable);
   bool isRepeatable();


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CImageButton)
	public:
	virtual void DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct);
	protected:
	virtual LRESULT WindowProc(UINT message, WPARAM wParam, LPARAM lParam);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CImageButton();

	// Generated message map functions
protected:
	//{{AFX_MSG(CImageButton)
	afx_msg void OnSetFocus( CWnd* pOldWnd );
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_IMAGEBUTTON_H__65ED1E04_41BD_11D3_9A60_0040332C7B2F__INCLUDED_)
