#include "StdAfx.h"

#include "MSystemManager.h"
#include <params/MFloatKeyParameter.h>

#include "MDAGraph.h"

#include <algorithm>

#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

namespace Aztec {

  //---------------------
  //  MFloatKeyParameter
  //---------------------
  MFloatKeyParameterImpl::MFloatKeyParameterImpl(
    const MStr &shortName, 
    const MStr &longName, 
    const MStr &friendlyName, 
    const MFloatKeyableValuePtr &inputFloatList) 
    : MFloatParameterImpl(shortName, longName, friendlyName)
  {
    if (inputFloatList != NULL) {
      m_FloatKeyList = inputFloatList;
    } else {
      m_FloatKeyList = new MFloatKeyList;
    }
    addInput(&*m_FloatKeyList);
  }
  
  MFloatKeyParameterImpl::~MFloatKeyParameterImpl() {
  }

  float MFloatKeyParameterImpl::getValue() {
    updateObject();
    return m_Value;
  }

  float MFloatKeyParameterImpl::getValue(long time) { 
    updateObject();
    return m_Value;
  }

  MKeyableValuePtr MFloatKeyParameterImpl::getKeyableValue() {
    return m_FloatKeyList;
  }

  bool MFloatKeyParameterImpl::setValueFloat(float value) {
    MFloatParameterImpl::setValueFloat(value);

    m_FloatKeyList->setInitialValue(m_Value);

    return true;
  }

  bool MFloatKeyParameterImpl::createKeyAt(long time) {
    m_FloatKeyList->setKey(m_Value, time);
    return true;
  }

  bool MFloatKeyParameterImpl::setFromParameter(MParameterObjectPtr src) {
    MFloatParameterImpl::setFromParameter(src);

    MKeyParameterPtr param = AZTEC_CAST(MKeyParameter, src);

    if (param != NULL) {
      getKeyableValue()->copyFromValue(param->getKeyableValue());
    }

    return true;
  }

  MParameterObjectPtr MFloatKeyParameterImpl::createCopy() {
    return createParameterCopy(this);
  }

  bool MFloatKeyParameterImpl::doUpdateObject() {
    MFloatParameterImpl::doUpdateObject();

    // if we have do not have a parameter as our input, then we update 
    // the value as we normally should
    if (getInputParameter() == NULL) {
      m_Value = m_FloatKeyList->getValueAtTime(getTime());
    }

    return true;
  }

}
