#include "StdAfx.h"

#include <mesh/MMeshCreator.h>
#include <params/MParameterFactory.h>

#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

namespace Aztec {

  MMeshCreator::MMeshCreator() {
    setObjectType(OBJECTFLAG_TYPE_MODIFIER);

    addParameter(outputShapeParam = MParameterFactory::createObject("out", "outMesh", "Output Mesh", false));
    outputShapeParam->setVisible(false);

    MMeshShapePtr tempShape = new MMeshShape();
    outputShapeParam->setValue(tempShape);
  }

  MMeshCreator::~MMeshCreator() {
  }

  MMeshShapePtr MMeshCreator::getOutputShape() {
    return AZTEC_CAST(MMeshShape, outputShapeParam->getValue());
  }

  MObjectParameterPtr MMeshCreator::getOutputParameter() {
    return outputShapeParam;
  }

}
