#include "StdAfx.h"

#include "MStreams.h"

#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

namespace Aztec {

  MOutputStream &operator <<(MOutputStream &out, char ch) {
    out.writeChar(ch);
    return out;
  }

  MOutputStream &operator <<(MOutputStream &out, int i) {
    out.writeInt(i);
    return out;
  }

  MOutputStream &operator <<(MOutputStream &out, long i) {
    out.writeInt(i);
    return out;
  }

  MOutputStream &operator <<(MOutputStream &out, float fl) {
    out.writeFloat(fl);
    return out;
  }

  MOutputStream &operator <<(MOutputStream &out, double dbl) {
    out.writeDouble(dbl);
    return out;
  }

  MOutputStream &operator <<(MOutputStream &out, bool b) {
    out.writeBoolean(b);
    return out;
  }

  MOutputStream &operator <<(MOutputStream &out, BYTE b) {
    out.writeUnsignedChar(b);
    return out;
  }

  MOutputStream &operator <<(MOutputStream &out, WORD w) {
    out.writeUnsignedShort(w);
    return out;
  }

  MOutputStream &operator <<(MOutputStream &out, DWORD dw) {
    out.writeUnsignedInt(dw);
    return out;
  }

  MOutputStream &operator <<(MOutputStream &out, const MStr &str) {
    out.writeString(str);
    return out;
  }

  MOutputStream &operator <<(MOutputStream &out, const char *str) {
    out.writeString(str);
    return out;
  }

  MOutputStream &operator <<(MOutputStream &out, const std::string &str) {
    out.writeString(str.c_str());
    return out;
  }


  MInputStream &operator >>(MInputStream &in, char &ch) {
    ch = in.readChar();
    return in;
  }

  MInputStream &operator >>(MInputStream &in, int &i) {
    i = in.readInt();
    return in;
  }

  MInputStream &operator >>(MInputStream &in, long &i) {
    i = in.readInt();
    return in;
  }

  MInputStream &operator >>(MInputStream &in, float &fl) {
    fl = in.readFloat();
    return in;
  }

  MInputStream &operator >>(MInputStream &in, double &dbl) {
    dbl = in.readDouble();
    return in;
  }

  MInputStream &operator >>(MInputStream &in, bool &b) {
    b = in.readBoolean();
    return in;
  }

  MInputStream &operator >>(MInputStream &in, BYTE &b) {
    b = in.readUnsignedChar();
    return in;
  }

  MInputStream &operator >>(MInputStream &in, WORD &w) {
    w = in.readUnsignedShort();
    return in;
  }

  MInputStream &operator >>(MInputStream &in, DWORD &dw) {
    dw = in.readUnsignedInt();
    return in;
  }

  MInputStream &operator >>(MInputStream &in, MStr &str) {
    str = in.readString();
    return in;
  }

  MInputStream &operator >>(MInputStream &in, char *str) {
    strcpy(str, in.readString().c_str());
    return in;
  }

  MInputStream &operator >>(MInputStream &in, std::string &str) {
    str = in.readString().c_str();
    return in;
  }


}