#include "StdAfx.h"
#include "MLookAt.h"

#include "MSystemManager.h"
#include <params/MParameterFactory.h>

#include <math.h>

#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

namespace Aztec {

  MLookAt::MLookAt() {
    addParameter(target = MParameterFactory::createObject("target", "target", "target"));
    addParameter(outputRotation = MParameterFactory::createVector3("rot", "rotation", "Output rotation", false));

    addParameter(inputParent = MParameterFactory::createObject("inParent", "inputParent", "Input Parent"));
    addParameter(inputTranslation = MParameterFactory::createVector3("inTrans", "inputTranslation", "Input Translation"));

    addParameter(sourceAxis = MParameterFactory::createVector3("sourceAxis", "sourceAxis", "Source Axis"));
    sourceAxis->setValueVector(MVector3(0,0,1));

    addParameter(roll = MParameterFactory::createFloat("roll", "roll", "Roll"));

    inputParent->setVisible(false);
    inputTranslation->setVisible(false);
    outputRotation->setVisible(false);
  }

  void MLookAt::setSource(MSceneObjectPtr sceneObj) {
    inputParent->setInputParameter(NULL);
    inputTranslation->setInputParameter(NULL);

    m_InitialRot = sceneObj->getTransformObject()->getRotateVector(sceneObj->getTime());

    inputParent->setInputParameter(sceneObj->findParameter("parent"));
    inputTranslation->setInputParameter(sceneObj->findParameter("Tsl"));
    sceneObj->findParameter("Rot")->setInputParameter(outputRotation);    
  }

  void MLookAt::setSourceAxis(const MVector3 &vector) {
    sourceAxis->setValueVector(vector);
  }

  MSceneObjectPtr MLookAt::getTarget() {
    return AZTEC_CAST(MSceneObject, target->getValue());
  }

  void MLookAt::setTarget(MSceneObjectPtr sceneObj) {
    target->setValue(sceneObj);
  }

  bool MLookAt::doUpdateObject() {
    MNamedObject::doUpdateObject();
    // we cannot do this if either our target or 
    // source is NULL.
    if (target->getValue() == NULL) {
      return true;
    }

    // here we do the rotation
    MScenePtr scene = MSystemManager::getInstance()->getScene();

    // This is the target vector
    MVector3 targetVector, tempVec;

    // This is the axis we will be rotating around to get to our 
    // target position.
    MVector3 rotateAxis;
    float rotateAngle;

    MMatrix4 initialXForm, finalXForm;

    targetVector = scene->objectToWorldSpace(MBaseObjectPtr(target->getValue()), targetVector);
    targetVector = scene->worldToObjectSpace(MBaseObjectPtr(inputParent->getValue()), targetVector);
    targetVector -= inputTranslation->getValue();

    initialXForm.convertFromEuler(m_InitialRot);

    tempVec = initialXForm * sourceAxis->getValue();

    // now the axis we have to rotate by is tempVec cross targetVector
    targetVector.normalize();
    rotateAxis = tempVec / targetVector;
    rotateAxis.normalize();
    rotateAngle = (float)acos(tempVec * targetVector);
    
    finalXForm = initialXForm;
    finalXForm.rotateWithVector(rotateAxis, rotateAngle);
    finalXForm.rotateWithVector(targetVector, (roll->getValue() / 180.0f) * 3.1415926535f);

    MVector3 value;

    finalXForm.convertToEuler(value);
    value *= (float)(180.0 / M_PI);

    outputRotation->setValueVector(value);

    return true;
  }


}