#ifndef Aztec_ResourceManager_Header
#define Aztec_ResourceManager_Header

#include <ModelGeneric.h>

#include <string>

namespace Aztec {

  class MGENEXPORT ResourceManager {
  public:
    static void addResourcePath(const std::string &path);

    /**
     * Tries to find a resource among all our resource paths. If it could 
     * fine the given resource, the full path name to that resource is 
     * returned. If it cannot be found, an empty string is returned.
     */
    static std::string locateResource(const std::string &resource);
  };

}

#endif