#ifndef Aztec_FileTools_Header
#define Aztec_FileTools_Header

#include <MSystemManager.h>
#include <string>


namespace Aztec {

  class FileTools {
  public:

    /**
     * This gets a filter string separating names and filters by |'s, and ending with a double ||.
     * @deprecated
     */
    template <class T>
    static std::string createFilterString(
      const std::vector<T> &translators, 
      bool addAllFilesFilter,
      bool addAllKnownFilter) 
    {
      std::string result;
      std::string allFormatsFilter;

      for (std::vector<T>::const_iterator it = translators.begin();
           it != translators.end();
           ++it) 
      {
        // Add in the all known filters if we want to.
        if (addAllKnownFilter) {
          if (allFormatsFilter.length() > 0) {
            allFormatsFilter += ";";
          }
          allFormatsFilter += (*it)->getFilter();
        }
        result += (*it)->getFilterDescription() + " (" + (*it)->getFilter() + ")|" + (*it)->getFilter() + "|";
      }

      if (addAllKnownFilter) {
        // prepend the all the formats filter
        std::string tempResult = result;
        result = "All Known Formats (";
        result += allFormatsFilter;
        result += ")|";
        result += allFormatsFilter;
        result += "|";
        result += tempResult;
      }

      if (addAllFilesFilter) {
        result += "All Files (*.*)|*.*|";
      }

      result += "|";
      return result;
    }
  };

}

#endif