#ifndef MIKController_Header
#define MIKController_Header

#include <ModelGeneric.h>

namespace Aztec {
  class MIKController;
  typedef MRefCountedPtr<MIKController> MIKControllerPtr;
}

#include <MNamedObject.h>
#include <MSceneObject.h>

namespace Aztec {
  class MGENEXPORT MIKController : public MNamedObject {
  public:
    MIKController();

    MSceneObjectPtr getStartBone();
    MSceneObjectPtr getEndBone();
    MSceneObjectPtr getEndEffector();

    MObjectParameterPtr getStartBoneParameter();
    MObjectParameterPtr getEndBoneParameter();
    MObjectParameterPtr getEndEffectorParameter();

  private:
    /**
     * This is the root bone of the bone chain that we will be modifying
     * to do our inverse kinematics.
     */
    MObjectParameterPtr startBoneParam;

    /**
     * This is the last bone in the chain that is modified by this 
     * inverse kinematics controller.
     */
    MObjectParameterPtr endBoneParam;

    /**
     * This is the object that we are attempting to place our endBone at.
     */
    MObjectParameterPtr endEffectorParam;

  };


}





#endif