#ifndef MTransformObject_Header
#define MTransformObject_Header

#include <ModelGeneric.h>

namespace Aztec {
  class MTransformObject;
  typedef MRefCountedPtr<MTransformObject> MTransformObjectPtr;
}

#define TRANSFORM_CHAN_TRANSX    0x0001
#define TRANSFORM_CHAN_TRANSY    0x0002
#define TRANSFORM_CHAN_TRANSZ    0x0004
#define TRANSFORM_CHAN_TRANSLATE 0x0007

#define TRANSFORM_CHAN_ROTATEX   0x0008
#define TRANSFORM_CHAN_ROTATEY   0x0010
#define TRANSFORM_CHAN_ROTATEZ   0x0020
#define TRANSFORM_CHAN_ROTATE    0x0038

#define TRANSFORM_CHAN_SCALEX    0x0040
#define TRANSFORM_CHAN_SCALEY    0x0080
#define TRANSFORM_CHAN_SCALEZ    0x0100
#define TRANSFORM_CHAN_SCALE     0x01C0

#define TRANSFORM_CHAN_ALL       0x01FF

#define TRANSFORMFLAG_DRAWAXIS   0x00000010

#include <MNamedObject.h>
#include <params/MVector3Parameter.h>
#include <params/MMatrix4Parameter.h>
#include <MVector3Value.h>

namespace Aztec {
  //--------------------
  //  MTransformObject
  //--------------------
  
  class MGENEXPORT MTransformObject : public MNamedObject {
  protected:
    MVector3ParameterPtr m_Translate;
    MVector3ParameterPtr m_Rotate;
    MVector3ParameterPtr m_Scale;
    MVector3ParameterPtr m_PivotPoint;
    MVector3 m_HoldTranslate;
    MVector3 m_HoldRotate;
    MVector3 m_HoldScale;
    MVector3 m_HoldPivot;
    MMatrix4ParameterPtr m_LocalMatrix;
    
  public:
    MTransformObject();
    virtual ~MTransformObject();
    
    virtual MStr getClassName() {return MStr("MTransformObject");};
    virtual MStr getParentClassName() {return MStr("MNamedObject");};
    virtual MBaseObjectPtr createNew();
    virtual void setFrom(MBaseObjectPtr SrcObj);
    
    const MVector3 getTranslateVector(long time);
    const MVector3 getRotateVector(long time);
    const MVector3 getScaleVector(long time);
    const MVector3 getPivotPoint();

    void setTranslateVector(const MVector3 &vec);
    void setRotateVector(const MVector3 &vec);
    void setScaleVector(const MVector3 &vec);
    void setPivotPoint(const MVector3 &vec);
    
    void getTransformMatrix(MMatrix4 &Matrix);
    
    void updateKey(int Time, DWORD Channel = TRANSFORM_CHAN_ALL, bool CreateKey = false);
    
    void holdValues();
    void fetchValues();
    
    MVector3ValuePtr getTranslateKey();
    MVector3ValuePtr getRotateKey();
    MVector3ValuePtr getScaleKey();

    // MBaseObject methods
    bool doUpdateObject();

  };
  
}


#endif
