#ifndef Aztec_MSelectionItem_Header
#define Aztec_MSelectionItem_Header

#include "ModelGeneric.h"
#include <MBaseObject.h>
#include <vector>
          
#define SELECTITEM_OBJECT     1
#define SELECTITEM_VERTEX     2
#define SELECTITEM_FACE       3
#define SELECTITEM_EDGE       4
#define SELECTITEM_UV_POINT   5
#define SELECTITEM_UV_EDGE    6
#define SELECTITEM_UV_FACE    7

#define SELECTITEM_BUF_GRANULARITY  32


namespace Aztec {

  class MGENEXPORT MSelectionItem {
  protected:
    MBaseObjectPtr m_Object;

    typedef std::pair<AztecFlags, int> ComponentType;
    std::vector<ComponentType> components;
    
  public:
    MSelectionItem();
    MSelectionItem(const MSelectionItem &src);
    MSelectionItem(MBaseObjectPtr SelObj);
    virtual ~MSelectionItem();
    
    void setObject(MBaseObjectPtr Obj);
    MBaseObjectPtr getObject() const;
    void addComponent(AztecFlags Type, int CompNum);
    void removeAllComponents();
    
    int getNumComponents() const;
    void getComponent(int Num, AztecFlags &Type, int &CompNum) const;
  };
  
  

}
#endif 
