#ifndef LightH
#define LightH

#include "ModelGeneric.h"

namespace Aztec {

  class MLight;

  typedef MRefCountedPtr<MLight> MLightPtr;

}

#include "MShapeObject.h"
#include "MMesh.h"
#include "MMath.h"

#define LIGHTFLAG_POINTLIGHT     0x00010000
#define LIGHTFLAG_LIGHTON        0x00020000

namespace Aztec {

  //----------------------------------------------------------------------------------------
  //  MLight
  //----------------------------------------------------------------------------------------
  class MGENEXPORT MLight : public MShapeObject {
  public:
    typedef MLightPtr Ptr;    
    
    MMeshPtr m_LightMesh;
    
    MLight();
    ~MLight();
    
    virtual MStr getClassName() {return MStr("MLight");};
    virtual MStr getParentClassName() {return MStr("MShapeObject");};
    virtual MBaseObjectPtr createNew();
    virtual void setFrom(MBaseObjectPtr SrcObj);
    
    virtual MMeshPtr convertToMesh();
    virtual bool drawObject(const MBaseObjectPtr &baseObj, MSceneViewFlags ViewFlags);
    virtual int selectComponent(AztecFlags Mode, int CompNum, bool TargetSel);
    
  };

}
#endif
