#ifndef MFloatKey_Header
#define MFloatKey_Header

#include "ModelGeneric.h"

namespace Aztec {
  class MFloatKey;
  typedef MRefCountedPtr<MFloatKey> MFloatKeyPtr;
}

#include "MKey.h"

namespace Aztec {

  /**
   * This is an interface class that defines how Vector3Key types must operate
   */
  class MGENEXPORT MFloatKey : public MKey {
  public:
    /**
     * This gets the value of the key
     */
    virtual float getValue() = 0;
    
    /**
     * Sets the value of the key
     */
    virtual void setValue(float value) = 0;
    
    /**
     * Returns the tangent of the key on its way in to this key
     */
    virtual float getInTangent() = 0;
    
    /**
     * Returns the tangent of the key on its way out from this key
     */
    virtual float getOutTangent() = 0;

    /**
     * This attempts to set the incoming tangent for the key.
     * This may not be possible as the tangents may be locked.
     */
    virtual void setInTangent(float in) = 0;

    /**
     * This attempts to set the outgoing tangent for the key.
     * This may not be possible as the tangents may be locked.
     */
    virtual void setOutTangent(float out) = 0;
  };
  

}

#endif 
