#include <AztecGUICommonPCH.h>

#include <gui/win32/MSliderImpl.h>
#include <gui/win32/MAppImpl.h>

#include <assert.h>

#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


namespace Aztec {

  MSlider::MSlider(int min, int max, int pos)
    : MComponent(), minSize(-1,-1)
  {
    startMin = min;
    startMax = max;
    startPos = pos;
  }

  MSlider::~MSlider() {
  }

  bool MSlider::createImpl() {
    MApp *app;
    HWND parentHWND = NULL;

    if (m_Parent != NULL) {
      parentHWND = m_Parent->getHWnd();
    }

    app = MApp::getInstance();

    m_hWnd = CreateWindowEx(0, TRACKBAR_CLASS, "", WS_CHILD | TBS_AUTOTICKS  | WS_TABSTOP, 
                            0, 10, 0, 10, parentHWND, NULL, app->getHInstance(), NULL); 
    
    if (m_hWnd != 0) {
      // now subclass us
      app->registerComponent(m_hWnd, this);

      ::SendMessage(m_hWnd, WM_SETFONT, (DWORD)::GetStockObject(DEFAULT_GUI_FONT), 0);

      ::SendMessage(m_hWnd, TBM_SETRANGEMIN, FALSE, startMin);
      ::SendMessage(m_hWnd, TBM_SETRANGEMAX, FALSE, startMax);
      ::SendMessage(m_hWnd, TBM_SETPOS, FALSE, startPos);

      onCreate();

      setVisible(true);
      ::UpdateWindow(m_hWnd);

      return true;
    }

    return false;
  }

  bool MSlider::wndProc(UINT message, WPARAM wParam, LPARAM lParam, LRESULT *result) {
    if (message == WM_HSCROLL) {
      onChanged();
      for (std::vector<SliderListenerPtr>::iterator i = listeners.begin(); i != listeners.end(); ++i) {
        (*i)->onChange(this);
      }
    }

    return MComponent::wndProc(message, wParam, lParam, result);
  }

  void MSlider::setValue(int value) {
    ::SendMessage(m_hWnd, TBM_SETPOS, TRUE, value);
    // we have to fire events manually, because this doesn't generate a WM_HSCROLL EVENT,
    onChanged();
    for (std::vector<SliderListenerPtr>::iterator i = listeners.begin(); i != listeners.end(); ++i) {
      (*i)->onChange(this);
    }
  }

  int MSlider::getValue() {
    return ::SendMessage(m_hWnd, TBM_GETPOS, 0, 0);
  }


  void MSlider::setRange(int min, int max) {
    ::SendMessage(m_hWnd, TBM_SETRANGEMIN, FALSE, min);
    ::SendMessage(m_hWnd, TBM_SETRANGEMAX, TRUE, max);
  }

  void MSlider::setMinimum(int min) {
    ::SendMessage(m_hWnd, TBM_SETRANGEMAX, TRUE, min);
  }

  void MSlider::setMaximum(int max) {
    ::SendMessage(m_hWnd, TBM_SETRANGEMAX, TRUE, max);
  }

  int MSlider::getMinimum() {
    return ::SendMessage(m_hWnd, TBM_GETRANGEMIN, 0, 0);
  }

  int MSlider::getMaximum() {
    return ::SendMessage(m_hWnd, TBM_GETRANGEMAX, 0, 0);
  }


  bool MSlider::onChanged() {
    return false;
  }

  void MSlider::addListener(const SliderListenerPtr &listener) {
    listeners.push_back(listener);
  }

  bool MSlider::isMinimumSizeSet() {
    return true;
  }

  MSize2D MSlider::getMinimumSize() {
    MSize2D a = MComponent::getMinimumSize();
    MSize2D b(getMaximum() - getMinimum(),30);

    return MSize2D::getLargest(a, b);
  }


}

