#include <AztecGUICommonPCH.h>
#include <gui/MSaveFileDialog.h>
#include <gui/MApplication.h>

namespace Aztec {
  MSaveFileDialog::MSaveFileDialog() {
    overwritePrompt = true;
  }

  void MSaveFileDialog::setOverwritePrompt(bool showPrompt) {
    overwritePrompt = showPrompt;
  }


  void MSaveFileDialog::setupOFN(OPENFILENAME &ofn) {
    MFileDialog::setupOFN(ofn);

    ofn.Flags |= OFN_HIDEREADONLY | OFN_PATHMUSTEXIST;

    if (overwritePrompt) {
      ofn.Flags |= OFN_OVERWRITEPROMPT;
    }
  }

  BOOL MSaveFileDialog::showDialog(OPENFILENAME &ofn) {
    return GetSaveFileName(&ofn);
  }

  void MSaveFileDialog::extractFilename(OPENFILENAME &ofn) {
    path = ofn.lpstrFile;
    filename = path.substr(ofn.nFileOffset);
    path = path.substr(0, ofn.nFileOffset);

    // check to make sure the filename has an extension.
    if (filename.rfind('.') == std::string::npos) {
      // if we have no extension, add one in.
      std::string filterString = filters[selectedFilter].second;

      // get rid of anything after and including the semi colon (in case there
      // are multiple filters)
      filterString = filterString.substr(0, filterString.find(';'));

      // now remove the wild cards if they exist.
      if (filterString.find("*.") != std::string::npos) {
        filterString = filterString.substr(filterString.find("*.") + 1);
      }

      // now append the filterString on to the filename.
      filename += filterString;
      
    }
  }

  int MSaveFileDialog::getWindowsFilters(std::string &ofnFilters) {
    int count = 0;
    ofnFilters = "";

    // with this, we first fill up the string with |'s as separators, and 
    // then replace those with nulls. We do this for debugging purposes, 
    // so it is easier to see the filters before they are placed in the string.

    for (unsigned int i = 0; i < filters.size(); ++i) {
      ofnFilters += filters[i].first + " (" + filters[i].second + ")";
      ofnFilters += '|';
      ofnFilters += filters[i].second;
      ofnFilters += '|';
      ++count;
    }

    ofnFilters += '|';

    // now go and replace all the |'s with nulls.
    for (unsigned int i = 0; i < ofnFilters.size(); ++i) {
      if (ofnFilters[i] == '|') {
        ofnFilters[i] = '\0';
      }
    }

    return count;
  }



}

