#include <AztecGUICommonPCH.h>

#include <gui/win32/MMenuImpl.h>

#include <gui/MApplication.h>

namespace Aztec {

#define OPTION_BOX_TEXT "*"
	




  unsigned short MMenu::m_lastID = 1000;

  unsigned short MMenu::getNewCommandID() {
    return ++m_lastID;
  }


  MMenu::MMenu() {
    // create our menu handle for future use
    m_hMenu = NULL;
  }

  MMenu::~MMenu() {
    m_Items.clear();

    // destroy the win32 menu
    if (m_hMenu != NULL) {
      ::DestroyMenu(m_hMenu);
    }

  }

  HMENU MMenu::getHMenu(bool asPopup) { 
    if (m_hMenu == NULL) {
      if (asPopup) {
        m_hMenu = ::CreatePopupMenu();
      } else {
        m_hMenu = ::CreateMenu();
      }

      // Add in any stored items in now.
      for (int i = 0; i < m_Items.size(); ++i) {
        MENUITEMINFO info = m_Items[i]->createMenuInfo();
        // Add the actual win32 menu item.
        BOOL result = ::InsertMenuItem(getHMenu(), i, TRUE, &info); 

        if (result == FALSE) {
          DWORD err = ::GetLastError();

          OutputDebugString("error creating menu!\n");
        }
      }

      updateOptionBoxes();
    } 

    return m_hMenu;
  }

  HMENU MMenu::getHMenuNoCreate() {
    return m_hMenu;
  }

  void MMenu::fixChildPositions() {
    for (int i = 0; i < m_Items.size(); ++i) {
      if (m_Items[i] == NULL) {
        continue;
      }

      m_Items[i]->m_Position = i;
    }
  }

  int MMenu::getItemCount() {
    return m_Items.size();
  }

  MMenuItemPtr MMenu::getItem(int index) {
    return m_Items[index];
  }

  void MMenu::addItem(MMenuItemPtr item) {
    MENUITEMINFO info;

    item->m_Parent = this;
    item->m_Position = m_Items.size();

    // if we don't have a valud menu yet, just store the menu item, and add it in officially, later.
    if (m_hMenu != NULL) {
      info = item->createMenuInfo();
      // Add the actual win32 menu item.
      BOOL result = ::InsertMenuItem(getHMenu(), m_Items.size(), TRUE, &info); 

      if (result == FALSE) {
        DWORD err = ::GetLastError();

        OutputDebugString("error creating menu!\n");
      }

    }      

    m_Items.push_back(item);

    updateOptionBoxes();

  }

  void MMenu::addItem(MMenuItemPtr item, int index) {
    MENUITEMINFO info;

    item->m_Parent = this;
    item->m_Position = m_Items.size();

    m_Items.insert(m_Items.begin() + index, item);

    // if we don't have a valud menu yet, just store the menu item, and add it in officially, later.
    if (m_hMenu != NULL) {
      info = item->createMenuInfo();
      // Add the actual win32 menu item.
      ::InsertMenuItem(getHMenu(), index, TRUE, &info); 

      updateOptionBoxes();
    }

    fixChildPositions();
  }

  void MMenu::addSeparator() {
    addItem(new MMenuItem(MMenuItem::SEPARATOR));
    // do nothing right now
  }

  void MMenu::addSeparator(int index) {
    addItem(new MMenuItem(MMenuItem::SEPARATOR), index);

    fixChildPositions();
  }

  void MMenu::removeItem(int index) {
    MMenuItemPtr item = m_Items[index];
    item->m_Parent = NULL;
    item->m_Position = -1;

    m_Items.erase(m_Items.begin() + index);
    fixChildPositions();

    // if we don't have a valud menu yet, just store the menu item, and add it in officially, later.
    if (m_hMenu != NULL) {
      ::RemoveMenu(getHMenu(), index, MF_BYPOSITION);
    }

  }

  bool MMenu::onItemClick(const MMenuItemPtr &item) {
    // Don't handle the message by default, so just return false.
    return false;
  }

  bool MMenu::popupMenu(const MComponentPtr &component, const MPoint2D &position) {
    // adjust the position so it is in screen space
    POINT point = { position.x, position.y };
    ::ClientToScreen(component->getHWnd(), &point);

    // display the popup, retriving the command that was clicked.
    DWORD result = ::TrackPopupMenu(getHMenu(true), TPM_LEFTALIGN | TPM_TOPALIGN | TPM_RETURNCMD | TPM_NONOTIFY, point.x, point.y, 0, component->getHWnd(), NULL);

    // If there was a command, then inform the application a command was executed.
    if (result != 0) {
      MAppPtr app = MApp::getInstance();
      MMenuItemPtr item = app->getItemFromID(result);

      if (item != NULL) {
        bool handled = false;
        if (result == item->getID()) {
          handled = app->onCommand(item->getCommand(), component);
        
          if (!handled) {
            item->doClick();
            handled = true;
          }

        } else if (result == item->getOptionID()) {
          handled = app->onCommand(item->getOptionCommand(), component);
        }

        return handled;

      } else {
        return false;
      }

    } else {
      return false;
    }
  }

  inline bool hasOptionBox(const MMenuItemPtr &item) {
    return item->getOptionCommand().length() > 0;
  }

  static MENUITEMINFO getInfoForOptionBox(const MMenuItemPtr &item) {
    MENUITEMINFO info;

    info.cbSize = sizeof(MENUITEMINFO);
    info.fMask = MIIM_TYPE | MIIM_ID;
    info.wID = item->getOptionID();
    info.fType = item->isSeparator() ? MFT_SEPARATOR : MFT_STRING;


    if (item->getOptionCommand().length() > 0) {
      info.dwTypeData = OPTION_BOX_TEXT;
    } else {
      info.dwTypeData = "";
      info.fMask |= MIIM_STATE;
      info.fState = MFS_DISABLED;
    }

    return info;
  }

  void MMenu::updateOptionBoxes() {
    if (m_hMenu == NULL) {
      return;
    }

    bool hasOptionBoxes = false;
    // check to see if any of the items have option boxes.
    for (int i = 0; i < m_Items.size(); ++i) {
      hasOptionBoxes |= hasOptionBox(m_Items[i]);
    }


    // remove all the old menus.
    while (GetMenuItemID(getHMenu(), m_Items.size()) != 0xFFFFFFFF) { 
      ::RemoveMenu(getHMenu(), m_Items.size(), MF_BYPOSITION);
    }

    if (hasOptionBoxes) {
      // check to see how many menu items there are. If there aren't the right amount fix it up

      for (int i = 0; i < m_Items.size(); ++i) {
        MENUITEMINFO info = getInfoForOptionBox(m_Items[i]);

        if (i == 0) {
          info.fType |= MFT_MENUBREAK;
        }

        ::InsertMenuItem(getHMenu(), m_Items.size() + i, TRUE, &info);
      }
    }
  }

}


