#include <AztecGUICommonPCH.h>

#include <gui/scripting/AztecGUIScripting.h>
#include <gui/MTextField.h>
namespace Aztec {

  static JSBool js_MTextField_constructor(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval);
  static JSBool js_method_getValue(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval);
  static JSBool js_prop_getValue(JSContext *cx, JSObject *obj, jsval id, jsval *rval);
  static JSBool js_getValue(JSContext *cx, JSObject *obj, jsval *rval);
  static JSBool js_prop_setValue(JSContext *cx, JSObject *obj, jsval id, jsval *js_value);
  static JSBool js_setValue(JSContext *cx, JSObject *obj, jsval js_value);
  static JSBool js_method_setValue(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval);
  static JSBool js_addAcceptListener(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval);
  static JSBool js_addCancelListener(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval);

  JSClass js_MTextField_class = {
    "MTextField", JSCLASS_HAS_PRIVATE,
      JS_PropertyStub, JS_PropertyStub,
      JS_PropertyStub, JS_PropertyStub,
      JS_EnumerateStub, JS_ResolveStub,
      JS_ConvertStub,   JS_FinalizeStub
  };
  
  JSFunctionSpec aztecMTextField_methods[] = {
    // Object/mesh creation
    {"getValue",  js_method_getValue,          0},
    {"setValue",  js_method_setValue,          1},
    {"addAcceptListener",        js_addAcceptListener,        3},
    {"addCancelListener",        js_addCancelListener,        3},
    {NULL,                NULL,                   0} 
  };
  
  static JSPropertySpec js_MTextField_props[] = {
    {"value", 0, JSPROP_ENUMERATE, js_prop_getValue, js_prop_setValue}, 
    {0, 0, 0, 0}
  };

  JSObject* initMTextFieldClass(JSContext *cx, JSObject *componentClass) {
    JSObject *cl = JS_InitClass(cx, JS_GetGlobalObject(cx), componentClass,
      &js_MTextField_class, js_MTextField_constructor, 0,
      NULL, aztecMTextField_methods, 0, 0);

    JS_DefineProperties(cx, cl, js_MTextField_props);
    
    return cl;
    
  }
  
  static JSBool js_MTextField_constructor(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval) {

    // we only accept 0, 1, or 2 arguments
    if (argc > 2) {
      return JS_FALSE;
    }

    std::string value;
    int32 width = -1;

    if (argc >= 1) {
      value = JS_GetStringBytes(JS_ValueToString(cx, argv[0]));
    }
    if (argc >= 2) {
      JS_ValueToInt32(cx, argv[1], &width);
    }

    MTextFieldPtr newComponent;
    
    if (width != -1) {
      newComponent = new MTextField(width);
    } else {
      newComponent = new MTextField();
    }
    newComponent->setValue(value);
    
    return JS_SetPrivate(cx, obj, new JS_GUIObject(newComponent));
  }

  static JSBool js_method_getValue(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval)
  {
    if (argc != 0) {
      JS_ReportError(cx, "getValue() requires one argument.");
      return JS_FALSE;
    }

    return js_getValue(cx, obj, rval);
  }

  static JSBool js_prop_getValue(JSContext *cx, JSObject *obj, jsval id, jsval *rval) {
    return js_getValue(cx, obj, rval);
  }

  static JSBool js_getValue(JSContext *cx, JSObject *obj, jsval *rval) {
    MTextFieldPtr textField = getGuiObject<MTextField>(cx, obj);
    
    if (textField != NULL) {
      *rval = STRING_TO_JSVAL( JS_NewStringCopyZ(cx, textField->getValue().c_str()) );
      return JS_TRUE;
    } else {
      return JS_FALSE;
    }
  }

  static JSBool js_method_setValue(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval)
  {
    if (argc != 1) {
      JS_ReportError(cx, "setValue() requires one argument.");
      return JS_FALSE;
    }
    
    return js_setValue(cx, obj, argv[0]);
  }

  static JSBool js_prop_setValue(JSContext *cx, JSObject *obj, jsval id, jsval *js_value) {
    return js_setValue(cx, obj, *js_value);
  }

  static JSBool js_setValue(JSContext *cx, JSObject *obj, jsval js_value)
  {
    MTextFieldPtr textField = getGuiObject<MTextField>(cx, obj);
    
    if (textField != NULL) {
      textField->setValue( JS_GetStringBytes( JS_ValueToString(cx, js_value) ) );
      return JS_TRUE;
    } else {
      return JS_FALSE;
    }
    
  }
  
  class JSTextFieldListener : public MTextField::TextListener {
  public:
    JSTextFieldListener(JSContext *cx, JSObject *obj, JSFunction *function, uintN argc, jsval *argv) {
      this->cx = cx;
      this->func = function;
      this->object = obj;
      for (uintN i = 0; i < argc; ++i) {
        args.push_back(argv[i]);
      }
    }

    void onListen(const MTextFieldPtr &field) {

      jsval rval;

      jsval *argv = new jsval[args.size() + 1];

      argv[0] = OBJECT_TO_JSVAL(object);
      for (int i = 0; i < args.size(); ++i) {
        argv[i+1] = args[i];
      }

      JS_CallFunction(cx, object, func, args.size() + 1, argv, &rval);

      delete[] argv;
    }

    JSContext *cx;
    JSFunction *func;
    JSObject *object;
    std::vector<jsval> args;
  };

  static JSBool js_addAcceptListener(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval) {
    if (argc < 1) {
      return JS_FALSE;
    }

    MTextFieldPtr component = getGuiObject<MTextField>(cx, obj);
    JSFunction *func = JS_ValueToFunction(cx, argv[0]);
    
    if (func != NULL && component != NULL) {

      component->addAcceptListener(new JSTextFieldListener(cx, obj, func, argc - 1, argv + 1));

      return JS_TRUE;
    } else {
      return JS_FALSE;
    }

    return JS_FALSE;
  }

  static JSBool js_addCancelListener(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval) {
    if (argc < 1) {
      return JS_FALSE;
    }

    MTextFieldPtr component = getGuiObject<MTextField>(cx, obj);
    JSFunction *func = JS_ValueToFunction(cx, argv[0]);
    
    if (func != NULL && component != NULL) {

      component->addCancelListener(new JSTextFieldListener(cx, obj, func, argc - 1, argv + 1));

      return JS_TRUE;
    } else {
      return JS_FALSE;
    }

    return JS_FALSE;
  }
}
