#include <AztecGUICommonPCH.h>

#include <gui/scripting/AztecGUIScripting.h>
#include <gui/MLabel.h>
namespace Aztec {

  static JSBool js_MLabel_constructor(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval);

  static JSBool js_method_getValue(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval);
  static JSBool js_prop_getValue(JSContext *cx, JSObject *obj, jsval id, jsval *rval);
  static JSBool js_getValue(JSContext *cx, JSObject *obj, jsval *rval);
  static JSBool js_prop_setValue(JSContext *cx, JSObject *obj, jsval id, jsval *js_value);
  static JSBool js_setValue(JSContext *cx, JSObject *obj, jsval js_value);
  static JSBool js_method_setValue(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval);

  JSClass js_MLabel_class = {
    "MLabel", JSCLASS_HAS_PRIVATE,
      JS_PropertyStub, JS_PropertyStub,
      JS_PropertyStub, JS_PropertyStub,
      JS_EnumerateStub, JS_ResolveStub,
      JS_ConvertStub,   JS_FinalizeStub
  };
  
  JSFunctionSpec aztecMLabel_methods[] = {
    // Object/mesh creation
    {"getValue",  js_method_getValue,          0},
    {"setValue",  js_method_setValue,          1},
    {NULL,                NULL,                   0} 
  };

  static JSPropertySpec js_MLabel_props[] = {
    {"value", 0, JSPROP_ENUMERATE, js_prop_getValue, js_prop_setValue}, 
    {0, 0, 0, 0}
  };
  
  JSObject* initMLabelClass(JSContext *cx, JSObject *componentClass) {
    JSObject *cl = JS_InitClass(cx, JS_GetGlobalObject(cx), componentClass,
      &js_MLabel_class, js_MLabel_constructor, 0,
      NULL, aztecMLabel_methods, 0, 0);

    JS_DefineProperties(cx, cl, js_MLabel_props);
    
    return cl;
    
  }
  
  static JSBool js_MLabel_constructor(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval) {

    // we only accept 0 or 1 arguments
    if (argc > 1) {
      return JS_FALSE;
    }

    std::string value;

    if (argc >= 1) {
      value = JS_GetStringBytes(JS_ValueToString(cx, argv[0]));
    }

    MLabelPtr newComponent = new MLabel();
    newComponent->setValue(value);
    
    return JS_SetPrivate(cx, obj, new JS_GUIObject(newComponent));
  }

  static JSBool js_method_getValue(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval)
  {
    if (argc != 0) {
      JS_ReportError(cx, "getValue() requires one argument.");
      return JS_FALSE;
    }

    return js_getValue(cx, obj, rval);
  }

  static JSBool js_prop_getValue(JSContext *cx, JSObject *obj, jsval id, jsval *rval) {
    return js_getValue(cx, obj, rval);
  }

  static JSBool js_getValue(JSContext *cx, JSObject *obj, jsval *rval) {
    MLabelPtr textField = getGuiObject<MLabel>(cx, obj);
    
    if (textField != NULL) {
      *rval = STRING_TO_JSVAL( JS_NewStringCopyZ(cx, textField->getValue().c_str()) );
      return JS_TRUE;
    } else {
      return JS_FALSE;
    }
  }

  static JSBool js_method_setValue(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval)
  {
    if (argc != 1) {
      JS_ReportError(cx, "setValue() requires one argument.");
      return JS_FALSE;
    }
    
    return js_setValue(cx, obj, argv[0]);
  }

  static JSBool js_prop_setValue(JSContext *cx, JSObject *obj, jsval id, jsval *js_value) {
    return js_setValue(cx, obj, *js_value);
  }

  static JSBool js_setValue(JSContext *cx, JSObject *obj, jsval js_value)
  {
    MLabelPtr textField = getGuiObject<MLabel>(cx, obj);
    
    if (textField != NULL) {
      textField->setValue( JS_GetStringBytes( JS_ValueToString(cx, js_value) ) );
      return JS_TRUE;
    } else {
      return JS_FALSE;
    }
    
  }
  
}
