/*

  Copyright (c) 2003 Phillip Martin
  Copyright (c) 2003 Richard van Eijbergen <richardve@users.sourceforge.net>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  2111-1307  USA

*/

#include <AztecGUICommonPCH.h>

#include "gui/qt3/MMenuItemImpl.h"
#include <gui/qt3/MAppImpl.h>


/**
 * Hide this away, should never be used outside.
 * This is also a nice way to keep the class views
 * in IDE's a bit more clean ;)
 */
namespace NS_hidden {

  /**
   * Unlike the win32 version, we're using integers because
   * Qt likes to use negative indices for menu items.
   */
  typedef std::map<int, Aztec::MMenuItem*> nsMenuItemMap;
  nsMenuItemMap g_mnmap;

  /**
   * Registers a menu item so it won't get lost by
   * the 'smart' pointer code (comment out the body
   * of this function and try to run Aztec to see
   * what I mean.. *crash*).
   */
  void registerMenu(Aztec::MMenuItem* item) {
    g_mnmap[item->getID()] = item;
  };

  void unregisterMenu(Aztec::MMenuItem* item) {
    g_mnmap.erase(item->getID());
  };
}



namespace Aztec {

  MMenuItem::MMenuItem(const std::string &caption, const std::string &command, const MMenuPtr &submenu)
    : m_ID(0) {
    init(caption, command, submenu);
  }

  MMenuItem::MMenuItem(const std::string &caption, const MMenuPtr &submenu)
    : m_ID(0) {
    init(caption, "", submenu);
  }


  MMenuItem::~MMenuItem() {
    NS_hidden::unregisterMenu(this);
//    MApp::getInstance()->unregisterMenu(this);
  }

  void MMenuItem::doClick() {
    if (!onClick()) {
      getParent()->onItemClick(this);
    }
  }


  // MComponentImpl methods

  bool MMenuItem::createImpl() {
    /**
     * Have to register the menu item here and
     * not in the c'tor because we don't have
     * a valid ID up there.
     */
    NS_hidden::registerMenu(this);
    return true;
  }

  void MMenuItem::setCaption(const std::string &caption) {
    m_Caption = caption;
  }

  std::string MMenuItem::getCaption() {
    return m_Caption;
  }

  void MMenuItem::setCommand(const std::string &command) {
    m_Command = command;
  }

  std::string MMenuItem::getCommand() {
    return m_Command;
  }

  void MMenuItem::setOptionCommand(const std::string &command) {
    m_OptionCommand = command;
  }

  std::string MMenuItem::getOptionCommand() {
    return m_OptionCommand;
  }

  void MMenuItem::setChecked(bool isChecked) {
    m_Checked = isChecked;
  }

  bool MMenuItem::getChecked() {
    return m_Checked;
  }

  void MMenuItem::setEnabled(bool isEnabled) {
    // TODO: Perhaps we're a little too paranoid here..
    if ((m_Parent != 0l) && (m_ID != 0)) {
      m_Parent->m_MenuHandle->setItemEnabled(m_ID, isEnabled);
    }
    m_Enabled = isEnabled;
  }

  bool MMenuItem::getEnabled() {
    return m_Enabled;
  }

  MMenuPtr MMenuItem::getSubMenu() {
    return m_SubMenu;
  }

  void MMenuItem::setSubMenu(const MMenuPtr &menu) {
    m_SubMenu = menu;
  }


  bool MMenuItem::onClick() {
    return false;
  }

  void MMenuItem::init(const std::string &caption, const std::string &command, const MMenuPtr &submenu) {
/*    if (caption == "|") { //SEPARATOR) {
      m_Caption = "";
      m_Separator = true;
    } else {*/
      m_Separator = false;
      m_Caption = caption;
/*    }*/

    m_Command = command;

    m_SubMenu = submenu;
    m_Checked = false;
    m_Enabled = true;

    m_ID = 0;

    m_Position = -1;
    m_Parent = NULL;

    //NS_hidden::registerMenu(this);
//    MApp::getInstance()->registerMenu(this);
  }


}

