/*

  Copyright (c) 2003 Phillip Martin
  Copyright (c) 2003 Richard van Eijbergen <richardve@users.sourceforge.net>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <AztecGUICommonPCH.h>

#include <gui/MComboBox.h>
#include <gui/qt3/MContainerImpl.h>
#include <gui/qt3/MAppImpl.h>

#include <gui/qt3/QComboBox_.moc>


namespace Aztec {

  using namespace std;

  MComboBox::MComboBox()
    : MComponent() {
  }

  MComboBox::~MComboBox() {
  }

  bool MComboBox::createImpl() {
    MApp* app;
    QWidget* parentWnd = 0l;

    // Get the parent widget handle, so we can create our button
    if (m_Parent != 0l) {
      parentWnd = m_Parent->getHandle();
    }

    app = MApp::getInstance();

    // create the actual widget
    m_Handle = new CQComboBox_(parentWnd, this);

    // if it succeeded, update everything
    if (m_Handle != 0) {
      // Register this widget with the application
      app->registerComponent(m_Handle, this);

      // Call the create event handler
      onCreate();

      return true;
    }

    return false;
  }

  void MComboBox::setValue(const string &value) {
    QComboBox* cb = dynamic_cast<QComboBox*>(m_Handle);
    if (cb != 0l) cb->setCurrentText(value.c_str());
  }

  string MComboBox::getValue() {
    QComboBox* cb = dynamic_cast<QComboBox*>(m_Handle);
    if (cb != 0l) return (std::string)cb->currentText();
    else return "";
  }

  void MComboBox::addItem(const string &item) {
    QComboBox* cb = dynamic_cast<QComboBox*>(m_Handle);
    if (cb != 0l) cb->insertItem(item.c_str());
  }

  void MComboBox::insertItem(const string &item, int index) {
    QComboBox* cb = dynamic_cast<QComboBox*>(m_Handle);
    if (cb != 0l) cb->insertItem(item.c_str(), index);
  }

  void MComboBox::removeItem(const string &item) {
    removeItem(findItem(item));
  }

  void MComboBox::removeItem(int index) {
    if (index < 0) return;

    QComboBox* cb = dynamic_cast<QComboBox*>(m_Handle);
    if (cb != 0l) cb->removeItem(index);
  }

  void MComboBox::removeAllItems() {
    QComboBox* cb = dynamic_cast<QComboBox*>(m_Handle);
    if (cb != 0l) cb->clear();
  }

  int MComboBox::findItem(const string &item) {
    // TODO: Implementation
    /*vector<string>::iterator it;
    int index = 0;

    for (it = m_Values.begin(); it != m_Values.end(); ++it) {
      if (*it == item) {
        return index;
      }
    }*/

    return -1;
  }


  int MComboBox::getItemCount() {
    QComboBox* cb = dynamic_cast<QComboBox*>(m_Handle);
    if (cb != 0l) return cb->count();
    else return 0;
  }


  int MComboBox::getSelectedIndex() {
    QComboBox* cb = dynamic_cast<QComboBox*>(m_Handle);
    if (cb != 0l) return cb->currentItem();
    else return 0;
  }

  string MComboBox::getSelectedItem() {
    QComboBox* cb = dynamic_cast<QComboBox*>(m_Handle);
    if (cb != 0l) (std::string)cb->currentText();
  }

  void MComboBox::setSelectedIndex(int index) {
    QComboBox* cb = dynamic_cast<QComboBox*>(m_Handle);
    if (cb != 0l) cb->setCurrentItem(index);
  }

  void MComboBox::setSelectedItem(const string &item) {
    QComboBox* cb = dynamic_cast<QComboBox*>(m_Handle);
    if (cb != 0l) cb->setCurrentText(item.c_str());
  }

  void MComboBox::showDropDown() {
    // TODO: Implementation
  }

  void MComboBox::hideDropDown() {
    // TODO: Implementation
  }

  bool MComboBox::isDropDownVisible() {
    // TODO: Implementation
    return false;
  }

  bool MComboBox::onChanged() {
    return false;
  }

  void MComboBox::addListener(const ComboBoxListenerPtr &listener) {
    listeners.push_back(listener);
  }

  void MComboBox::notifyListeners() {
    for (int i = 0; i < listeners.size(); ++i) {
      listeners[i]->onListen(this);
    }
  }

}

