#ifndef MWindowImpl_Header
#define MWindowImpl_Header

#include <gui/MWindow.h>
#include <gui/win32/MContainerImpl.h>

#include <string>

#include <windows.h>


namespace Aztec {

  class AZTECGUI_EXPORT MWindow : public virtual Aztec::IMWindow, public MContainer {
  public:

    MWindow(const std::string &title);
    ~MWindow();

    // MComponentImpl methods
    virtual bool createImpl();

    // MWindow methods
    bool create();
    void setTitle(const std::string &title);
    std::string getTitle();
    void setMenu(MMenuPtr menu);
    MMenuPtr getMenu();
    void close();
    bool onClose();

    // MComponent methods
    MSize2D getMinimumSize();
    MSize2D getPreferredSize();

  protected:
    /**
     * This is the title that appears in the window title bar.
     */
    std::string m_Title;

    /**
     * This is the menu for this window, if any.
     */
    MMenuPtr m_Menu;

    bool doCreateImpl(DWORD style, DWORD styleExtended, const MWindowPtr &parent = NULL);
  };

}

#endif