#ifndef MScrolledContainerImpl_Header
#define MScrolledContainerImpl_Header

#include <gui/MScrolledContainer.h>

#include <string>


namespace Aztec {

  class AZTECGUI_EXPORT MScrolledContainer : public virtual Aztec::IMScrolledContainer, 
                                             public MContainer {
  public:
    MScrolledContainer();

    // IMScrolledContainer methods
    void setVisibility(ScrollBarEnum scroller, VisiblityEnum visibility);
    VisiblityEnum getVisibility(ScrollBarEnum scroller);
    bool onScrolled(ScrollBarEnum scroller);

    // MContainer methods
    int getComponentCount();
    Aztec::MComponentPtr getComponent(int index);
    void addComponent(Aztec::MComponentPtr component);
    void addComponent(Aztec::MComponentPtr component, int index);
    void addComponent(Aztec::MComponentPtr component, Aztec::MConstraint constraints);
    void addComponent(Aztec::MComponentPtr component, int index, Aztec::MConstraint constraints);
    void removeComponent(int index);
    void removeComponent(Aztec::MComponentPtr component);
    int getComponentIndex(Aztec::MComponentPtr component);
    void setLayoutManager(Aztec::MLayoutManagerPtr layout);
    MLayoutManagerPtr getLayoutManager();
    void doLayout();

    // MComponentImpl methods
    bool createImpl();
    bool wndProc(UINT message, WPARAM wParam, LPARAM lParam, LRESULT *result);



  private:

    void setScrollVisible(ScrollBarEnum scroller, bool visible);
    void scrollContainer(int dx, int dy);
    MPoint2D scrollPos;

    VisiblityEnum horzVisibility;
    VisiblityEnum vertVisibility;
    bool vertVisible;
    bool horzVisible;

    MRect2D getValidScrollRect();
    MSize2D getChildSize();
    void updateScrollInfo();

    MContainerPtr content;
  };

  typedef MRefCountedPtr<MScrolledContainer> MScrolledContainerPtr;
}


#endif
