#ifndef MComboBoxImpl_Header
#define MComboBoxImpl_Header

#include <AztecGUICommon.h>

#include <string>
#include <vector>

#include <windows.h>

namespace Aztec {

  class AZTECGUI_EXPORT MComboBox : public virtual Aztec::IMComboBox, public MComponent {
  public:
    MComboBox();
    ~MComboBox();

    /**
     * This sets the internal value of the combo box, without 
     * setting the value in the concrete win32 object, and
     * without firing any events.
     *
     * @param value The new value for the text field.
     */
    void setInternalValue(const std::string &value);

    // MComponentImpl methods
    virtual bool createImpl();
    virtual bool handleWMCommandNotify(int notifyCode, int id);

    // MComboBox Methods
    void setValue(const std::string &value);
    std::string getValue();

    void addItem(const std::string &item);
    void insertItem(const std::string &item, int index);
    void removeItem(const std::string &item);
    void removeItem(int index);
    void removeAllItems();
    int findItem(const std::string &item);

    int getItemCount();

    int getSelectedIndex();
    std::string getSelectedItem();
    void setSelectedIndex(int index);
    void setSelectedItem(const std::string &item);

    void showDropDown();
    void hideDropDown();
    bool isDropDownVisible();

    bool onChanged();
    void addListener(const ComboBoxListenerPtr &listener);

    // MComponent methods
    void setPosition(int X, int Y, int width, int height);
    void setSize(const MSize2D &size);
    void setSize(int width, int height);
    bool isMinimumSizeSet();
    MSize2D getMinimumSize();



  protected:
    /**
     * This is the current value of the combo box's text field.
     */
    std::string m_Value;

    /**
     * The current selection in the combo box's list of entries.
     */
    int m_SelIndex;

    /**
     * This is the list of values that appear in the combo box.
     */
    std::vector<std::string> m_Values;

    std::vector<ComboBoxListenerPtr> listeners;

    void notifyListeners();
  };

}


#endif