
#ifndef Aztec_MImageComponentImpl_Header
#define Aztec_MImageComponentImpl_Header

#include <gui/MImageComponent.h>
#include <gui/qt3/MComponentImpl.h>


namespace Aztec {

  class AZTECGUI_EXPORT MImageComponent : public virtual Aztec::IMImageComponent, public MComponent {
  public:
    MImageComponent();
    ~MImageComponent();

    /**
     * This creates the implementation window
     */
    virtual bool createImpl();

    // MImageComponent Methods
    virtual void setImage(const MImagePtr &image);
    virtual MImagePtr getImage();

    // MComponent methods
    MSize2D getMinimumSize();
    bool isMinimumSizeSet();
    bool onPaint();

  protected:
    //MDIBImage bitmap;
    MImagePtr image;
    bool imageChanged;
  };


  typedef MRefCountedPtr<MImageComponent> MImageComponentPtr;

}


#endif

