
#ifndef MContainerImpl_Header
#define MContainerImpl_Header

#include <gui/qt3/MContainerImpl.h>
#include <gui/MLayoutManager.h>

#include <string>
#include <vector>


// Extern
class CQContainer_;


namespace Aztec {

  class AZTECGUI_EXPORT MContainer : public virtual Aztec::IMContainer, public MComponent {
    friend class CQContainer_;

  public:
    MContainer();
    MContainer(const std::string &name);
    MContainer(Aztec::MContainerPtr parent);
    MContainer(const std::string &name, Aztec::MContainerPtr *parent);
    MContainer(int X, int Y, int width, int height);
    ~MContainer();

    // MComponentImpl methods
    bool createImpl();

    // MContainer Methods
    int getComponentCount();
    Aztec::MComponentPtr getComponent(int index);
    void addComponent(Aztec::MComponentPtr component);
    void addComponent(Aztec::MComponentPtr component, int index);
    void addComponent(Aztec::MComponentPtr component, Aztec::MConstraint constraints);
    void addComponent(Aztec::MComponentPtr component, int index, Aztec::MConstraint constraints);
    void removeComponent(int index);
    void removeComponent(Aztec::MComponentPtr component);
    int getComponentIndex(Aztec::MComponentPtr component);
    void setLayoutManager(Aztec::MLayoutManagerPtr layout);
    MLayoutManagerPtr getLayoutManager();
    void doLayout();
    Aztec::MSize2D getClientSize();
    bool onCommand(const std::string &command, const MComponentPtr &component);

    // MComponent Methods
    Aztec::MSize2D getMinimumSize();
    Aztec::MSize2D getPreferredSize();
    void refresh();
    bool onResize(int newWidth, int newHeight);
    bool onShow();

  protected:
    /**
     * This is the children in the container
     */
    std::vector<Aztec::MComponentPtr> m_Children;

    /**
     * This is the layout manager to use for organising the components
     */
    Aztec::MLayoutManagerPtr m_LayoutManager;
  
  };

}


#endif

