#ifndef MTabbedContainer_Header
#define MTabbedContainer_Header

#include "MRefCountedPtr.h"

namespace Aztec {

  class MTabbedContainer;
  typedef MRefCountedPtr<MTabbedContainer> MTabbedContainerPtr;

}

#include <gui/MContainer.h>

#include <string>

namespace Aztec {

  /**
   */
  class AZTECGUI_EXPORT IMTabbedContainer : public virtual IMContainer {
  public:
    virtual MContainerPtr addPane(const std::string &label) = 0;
    virtual int getPaneCount() const = 0;
    virtual int getCurrentPane() const = 0;

  };

}


/**
 * The following header is included via the AZTEC_GUI
 * variable that should be defined for each platform
 * and used to specify an include directory
 * (ie. ../AztecGUICommon/include/gui/$(AZTEC_GUI)
 * when compiling this lib
 */
#include <MTabbedContainerImpl.h>


#endif

