#ifndef Aztec_GUICommon_MLabel_Header
#define Aztec_GUICommon_MLabel_Header

#include <MRefCountedPtr.h>

namespace Aztec {

  class IMLabel;
  class MLabel;

  typedef MRefCountedPtr<IMLabel> IMLabelPtr;
  typedef MRefCountedPtr<MLabel> MLabelPtr;

}

#include <gui/MComponent.h>

#include <string>


namespace Aztec {

  /**
   * This class represents a simple text entry field. The user can type in 
   * letters or numbers into the field and perform simple copy and paste 
   * operations.
   */
  class AZTECGUI_EXPORT IMLabel : public virtual IMComponent {
  protected:
    IMLabel() { }
    ~IMLabel() { }

  public:
    typedef IMLabelPtr Ptr;

    /**
     * Sets the current value for the text field. After setting this value, 
     * it should appear inside the edit control, and the onChange() method 
     * should be called.
     */
    virtual void setValue(const std::string &value) = 0;

    /**
     * Gets the current value for the text field. 
     */
    virtual std::string getValue() = 0;

    /**
     * This is called after the value in the box has been changed.
     */
    virtual bool onChanged() = 0;

  };

}


/**
 * The following header is included via the AZTEC_GUI
 * variable that should be defined for each platform
 * and used to specify an include directory
 * (ie. ../AztecGUICommon/include/gui/$(AZTEC_GUI)
 * when compiling this lib
 */
#include <MLabelImpl.h>


#endif

