#ifndef Aztec_MImageComponent_Header
#define Aztec_MImageComponent_Header

#include "MRefCountedPtr.h"

namespace Aztec {

  class MImageComponent;
  typedef MRefCountedPtr<MImageComponent> MImageComponentPtr;

}

#include <gui/MComponent.h>
#include <gui/MLayoutManager.h>

#include <string>

#include <MImages.h>

namespace Aztec {

  /**
   * This is a simple control that displays an image at full size.
   */
  class AZTECGUI_EXPORT IMImageComponent : public virtual IMComponent {
  public:
    virtual void setImage(const MImagePtr &image) = 0;
    virtual MImagePtr getImage() = 0;
  };

}


/**
 * The following header is included via the AZTEC_GUI
 * variable that should be defined for each platform
 * and used to specify an include directory
 * (ie. ../AztecGUICommon/include/gui/$(AZTEC_GUI)
 * when compiling this lib
 */
#include <MImageComponentImpl.h>


#endif

